% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSWCapabilities.R
\docType{class}
\name{CSWCapabilities}
\alias{CSWCapabilities}
\title{CSWCapabilities}
\format{\code{\link{R6Class}} object.}
\usage{
CSWCapabilities
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Catalogue Service for the Web (CSW) Get Capabilities document.
}
\description{
CSWCapabilities
}
\note{
Class used to read a \code{CSWCapabilities} document. The use of \code{CSWClient} is
recommended instead to benefit from the full set of capabilities associated to a CSW server.
}
\section{Methods}{

\describe{
 \item{\code{new(url, version, logger)}}{
   This method is used to instantiate a WFSGetCapabilities object
 }
}
}

\examples{
\donttest{
   #example based on CSW endpoint responding at http://localhost:8000/csw
   caps <- CSWCapabilities$new("http://localhost:8000/geonetwork/csw", version = "2.0.2")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{CSW}
\keyword{Capabilities}
\keyword{OGC}
