% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSWClient.R
\docType{class}
\name{CSWClient}
\alias{CSWClient}
\title{CSWClient}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Catalogue Service for the Web.
}
\description{
CSWClient
}
\section{Methods}{

\describe{
 \item{\code{new(url, serviceVersion, user, pwd, token, headers, logger, ...)}}{
   This method is used to instantiate a CSWClient with the \code{url} of the
   OGC service. Authentication is supported using basic auth (using \code{user}/\code{pwd} arguments), 
   bearer token (using \code{token} argument), or custom (using \code{headers} argument). By default, the \code{logger}
   argument will be set to \code{NULL} (no logger). This argument accepts two possible 
   values: \code{INFO}: to print only \pkg{ows4R} logs, \code{DEBUG}: to print more verbose logs
 }
 \item{\code{getCapabilities()}}{
   Get service capabilities.
 }
 \item{\code{reloadCapabilities()}}{
   Reload service capabilities
 }
 \item{\code{describeRecord(namespace, ...)}}{
   Describe records. Retrieves the XML schema for CSW records. By default, returns the XML schema 
   for the CSW records (http://www.opengis.net/cat/csw/2.0.2). For other schemas, specify the
   \code{outputSchema} required, e.g. http://www.isotc211.org/2005/gmd for ISO 19115/19139 schema
 }
 \item{\code{getRecordById(id, elementSetName, ...)}}{
   Get a record by Id. By default, the record will be returned following the CSW schema 
   (http://www.opengis.net/cat/csw/2.0.2). For other schemas, specify the \code{outputSchema} 
   required,  e.g. http://www.isotc211.org/2005/gmd for ISO 19115/19139 records.
   The parameter \code{elementSetName} should among values "full", "brief", "summary". The default
   "full" corresponds to the full metadata sheet returned. "brief" and "summary" will contain only
   a subset of the metadata content.
 }
 \item{\code{getRecords(query, maxRecords, maxRecordsPerRequest)}}{
   Get records based on a query, object of class \code{CSWQuery}. The maximum number of records can be
   set either for the full query (\code{maxRecords}) or per request (\code{maxRecordsPerRequest}, default set to 10 records)
   considering this operation is paginated. By default, the record will be returned following the CSW schema 
   (http://www.opengis.net/cat/csw/2.0.2). For other schemas, specify the \code{outputSchema} 
   required,  e.g. http://www.isotc211.org/2005/gmd for ISO 19115/19139 records.
 }
 \item{\code{transaction(type, record, recordProperty, constraint)}}{
   Generic transaction method. Used for inserting, updating or deleting metadata using the transactional CSW service.
   The \code{type} gives the type of transaction (Insert, Update, or Delete). The record
 }
 \item{\code{insertRecord(record, ...)}}{
   Inserts a new record
 }
 \item{\code{updateRecord(record, recordProperty, constraint, ...)}}{
   Updates an existing \code{record}. It can be a partial update by specifying a \code{recordProperty}.
   A constraint (object of class \code{CSWConstraint}) can be specified. 
 }
 \item{\code{deleteRecord(record, constraint, ...)}}{
   Deletes an existing \code{record}.  A constraint (object of class \code{CSWConstraint}) can be specified to limit
   the deletion to some records.
 }
 \item{\code{deleteRecordById(record, ...)}}{
   Deletes an existing record by identifier (constraint used to identify the record based on its identifier).
 }
 \item{\code{harvestRecord(sourceUrl, resourceType)}}{
   Harvests a single record from a \code{sourceUrl}, given a \code{resourceType} (by default "http://www.isotc211.org/2005/gmd").
 }
 \item{\code{harvestNode(url, query, resourceType, sourceBaseUrl)}}{
   Harvests a CSW node (having its endpoint defined by an  \code{url}). A \code{query} (object of class \code{CSWQuery}) can be
   specificed if needed to restrain the harvesting to a subset. The \code{resourceType} defines the type of resources to be harvested
   (by default "http://www.isotc211.org/2005/gmd")
 }
}
}

\examples{
\donttest{
   #example based on CSW endpoint responding at http://localhost:8000/csw
   csw <- CSWClient$new("http://localhost:8000/csw", serviceVersion = "2.0.2")
   
   #get capabilities
   caps <- csw$getCapabilities()
   
   #get records
   records <- csw$getRecords()
   
   #get record by id
   record <- csw$getRecordById("my-metadata-id")
   
   #Advanced examples at https://github.com/eblondel/ows4R/wiki#csw
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{CSW}
\keyword{OGC}
\keyword{catalogue}
\keyword{service}
\keyword{web}
