% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCODE.R
\name{pcode_missing}
\alias{pcode_missing}
\title{Parameter Cascade Method for Ordinary Differential Equation Models with missing state variable}
\usage{
pcode_missing(data, time, ode.model, par.names, state.names,
                     likelihood.fun,par.initial, basis.list,lambda,controls)
}
\arguments{
\item{data}{A data frame or a matrix contain observations from each dimension of the ODE model.}

\item{time}{A vector contain observation times or a matrix if time points are different between dimensions.}

\item{ode.model}{An R function that computes the time derivative of the ODE model given observations of states variable and structural parameters.}

\item{par.names}{The names of structural parameters defined in the 'ode.model'.}

\item{state.names}{The names of state variables defined in the 'ode.model'.}

\item{likelihood.fun}{A likelihood function passed to PCODE in case of that the error termsdevtools::document()do not have a Normal distribution.}

\item{par.initial}{Initial value of structural parameters to be optimized.}

\item{basis.list}{A list of basis objects for smoothing each dimension's observations. Can be the same or different across dimensions.}

\item{lambda}{Penalty parameter.}

\item{controls}{A list of control parameters. See Details.}
}
\value{
\item{structural.par}{The structural parameters of the ODE model.}

\item{nuisance.par}{The nuisance parameters or the basis coefficients for interpolating observations.}
}
\description{
Obtain estiamtes of both structural and nuisance parameters of an ODE model by parameter cascade method when the dynamics are partially observed.
}
\details{
The \code{controls} argument is a list providing addition inputs for the nonlinear least square optimizer or general optimizer \code{optim}:
\itemize{
\item \code{nquadpts} Determine the number of quadrature points for approximating an integral. Default is 101.
\item \code{smooth.lambda} Determine the smoothness penalty for obtaining initial value of nuisance parameters.
\item \code{tau} Initial value of Marquardt parameter. Small values indicate good initial values for structural parameters.
\item \code{tolx} Tolerance for parameters of objective functions. Default is set at 1e-6.
\item \code{tolg} Tolerance for the gradient of parameters of objective functions. Default is set at 1e-6.
\item \code{maxeval} The maximum number of evaluation of the optimizer. Default is set at 20.
}
}
