% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappingFunctions.R
\name{PM.getModel}
\alias{PM.getModel}
\title{Returns a model (XML or else)}
\usage{
PM.getModel(PM.obj, kindOfOutput = "XML")
}
\arguments{
\item{PM.obj}{a Process Mining model previously instantiated via the appropriate class (in example \code{alphaAlgorithm()}  or \code{firstOrderMarkovModel()}) or \code{AA.builder()} wrapper function}

\item{kindOfOutput}{a string indicating the kind of desired output. Can be "\code{XML}" or "\code{grViz}"}
}
\value{
the desided output, according with indicated by \code{kindOfOutput} input parameter
}
\description{
This function wraps the \code{<object>::getModel() } method and returns a Process Mining model, for example in XML or grViz format
}
\examples{
\dontrun{
# Instantiate a'firstOrderMarkovModel' model
obj.LD<-LD.builder()

# Load a CSV into the loader
LD.load.csv(loader.obj = obj.LD ,nomeFile = "../csv/dati_retto.csv",
               IDName = "CODICE_SANITARIO_ADT",EVENTName = "CAT1")

# Instantiate a PM model
obj.PM <-PM.builder(kindOfObject = "alphaAlgorithm")

# Load the previously loaded csv into the PM model
PM.loadDataset(PM.obj = obj.PM,dataList = LD.getData(loader.obj = obj.LD))

# train the model! 
PM.getModel(PM.obj = obj.PM, kindOfOutput = "XML")
} 
}

