% Generated by roxygen2 (4.0.1): do not edit by hand
\name{init}
\alias{init}
\title{Initialize Packrat on a new or existing \R project}
\usage{
init(project = ".", options = NULL, enter = TRUE, restart = enter)
}
\arguments{
\item{project}{The directory that contains the \R project.}

\item{options}{An \R \code{list} of options, as specified in
\code{\link{packrat-options}}.}

\item{enter}{Boolean, enter packrat mode for this project after finishing a init?}

\item{restart}{If \code{TRUE}, restart the R session after init.}
}
\description{
Given a project directory, makes a new packrat project in the directory.
}
\details{
\code{init} works as follows:

\enumerate{

\item Application dependencies are computed by examining the \R code
throughout the project for \code{library} and \code{require} calls.

\item A snapshot is taken of the version of each package currently used by
the project as described in \code{\link{snapshot}}, and each package's
sources are downloaded.

\item A private library is created in the directory.

\item The snapshot is applied to the directory as described in
\code{\link{restore}}. } When \code{init} is finished, all the packages
on which the project depends are installed in a new, private library located
inside the project directory.

\strong{You must restart your \R session in the given project directory after
running \code{init} in order for the changes to take effect!}

When \R is started in the directory, it will use the new, private library.
Calls to \code{\link{require}} and \code{\link{library}} will load packages
from the private library (except for 'base' or 'recommended' \R packages,
which are found in the system library), and functions such as \code{\link{install.packages}}
will modify that private library. You can sync this private library with
packrat using \code{\link{snapshot}} and \code{\link{restore}}.
}
\note{
The \code{restart} parameter will only result in a restart of R when the
R environment packrat is running within makes available a restart function
via \code{getOption("restart")}.
}
\examples{
\dontrun{

## initialize a project using a local repository of packages
packrat::init(options = list(local.repos = "~/projects/R"))

}
}
\seealso{
\link{packrat} for a description of the files created by
  \code{init}.
}

