% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{lib_validate}
\alias{lib_validate}
\title{Validate the local library}
\usage{
lib_validate(
  lib.loc = NULL,
  fields = c("Depends", "Imports", "LinkingTo"),
  lifeduration = FALSE,
  checkred = list(scope = character(0), flavors = NULL),
  repos = "https://cran.rstudio.com/"
)
}
\arguments{
\item{lib.loc}{character. Default: NULL}

\item{fields}{character vector with possible values \code{c("Depends", "Imports", "LinkingTo", "Suggests")}. Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lifeduration}{logical if to add life duration column, might take some time. Default: FALSE}

\item{checkred}{list with two named fields, \code{scope} and \code{flavor}. \code{scope} of R CRAN check pages statuses to consider, any of \code{c("ERROR", "FAIL", "WARN", "NOTE")}. \code{flavor} is a vector of CRAN machines to consider, which might be retrieved with \code{pacs::cran_flavors()$Flavor}. By default an empty scope field deactivated assessment for \code{checkred} column, and NULL flavor will results in checking all machines. Default \code{list(scope = character(0), flavor = NULL)}}

\item{repos}{character the base URL of the repository to use. Used only for the validation. Default \verb{https://cran.rstudio.com/}}
}
\value{
data.frame with 5/6/7 columns.
\describe{
\item{Package}{character a package name.}
\item{Version.expected.min}{character expected by DESCRIPTION files minimal version. "" means not specified so the newest version.}
\item{Version.have}{character installed package version.}
\item{version_status}{ numeric -1/0/1 which comes from \code{utils::compareVersion} function.
0 means that we have the same version as required by DESCRIPTION files. -1 means we have too low version installed, this is an error. 1 means we have higher version.}
\item{newest}{logical if the installed version is the newest one.}
\item{checkred}{(Optional) logical if the NEWEST package contains any specified statuses on CRAN check page. \code{pacs::checked_packages} is used to quickly retrieve all statuses at once.}
\item{lifeduration}{(Optional) integer number of days a package was released.}
}
}
\description{
Checking if installed packages have correct versions taking into account all DESCRIPTION files requirements.
Moreover identifying which packages are newest releases.
Optionally we could add life duration and CRAN check page status for each package.
}
\note{
Version.expected.min column not count packages which are not a dependency for any package, so could not be find in DESCRIPTION files.
When turn on the \code{lifeduration} options, calculations might be time consuming.
Results are cached for 1 hour with \code{memoise} package.
}
\examples{
\dontrun{
lib_validate()
lib_validate(checkred = list(scope = c("ERROR", "FAIL", "WARN")))
lib_validate(checkred = list(scope = c("ERROR", "FAIL"),
             flavors = cran_flavors()$Flavor[1:2]))
# activate lifeduration argument, could be time consuming for bigger libraries.
lib_validate(lifeduration = TRUE,
             checkred = list(scope = c("ERROR", "FAIL")))
}
}
