% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.data.R
\docType{data}
\name{loanbook_demo}
\alias{loanbook_demo}
\title{A loanbook dataset for demonstration}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 283 rows and 13 columns.
}
\usage{
loanbook_demo
}
\description{
Fake financial portfolio.

Demo datasets are synthetic because most financial data is strictly private;
they help to demonstrate and test the implementation in R of 'PACTA'
(\url{https://www.transitionmonitor.com/}).
}
\section{Definitions}{


\itemize{
\item \code{id_direct_loantaker} (character): Borrower identifier unique to each borrower/sector combination in loanbook., * \code{id_loan} (character): Unique loan identifier., * \code{id_ultimate_parent} (character): Ultimate parent identifier unique to each ultimate parent/sector combination., * \code{isin_direct_loantaker} (logical): Optional input: providing the isin identifier of the direct loan taker to improve the matching coverage., * \code{lei_direct_loantaker} (logical): Optional input: providing the lei (legal entity identifier) of the direct loan taker to improve the matching coverage., * \code{loan_size_credit_limit} (double): Total credit limit or exposure at default., * \code{loan_size_credit_limit_currency} (character): Currency corresponding to credit limit., * \code{loan_size_outstanding} (double): Amount drawn by borrower from total credit limit., * \code{loan_size_outstanding_currency} (character): Currency corresponding to outstandings., * \code{name_direct_loantaker} (character): Name of the company directly taking the loan., * \code{name_ultimate_parent} (character): Name of the ultimate parent company to which the borrower belongs. Can be the same as borrower., * \code{sector_classification_direct_loantaker} (double): Sector classification code of the direct loantaker., * \code{sector_classification_system} (character): Name of the sector classification standard being used.
}

}

\examples{
head(loanbook_demo)
}
\seealso{
Other demo data: 
\code{\link{abcd_demo}},
\code{\link{co2_intensity_scenario_demo}},
\code{\link{market_share}},
\code{\link{overwrite_demo}},
\code{\link{region_isos_demo}},
\code{\link{scenario_demo_2020}},
\code{\link{sda}}
}
\concept{demo data}
\keyword{datasets}
