% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yield_monitor.R
\name{pa_make_vehicle_polygons}
\alias{pa_make_vehicle_polygons}
\title{Make vehicular polygons for yield monitor
  observations}
\usage{
pa_make_vehicle_polygons(
  points,
  swath,
  distance,
  angle = NULL,
  cores = 1L,
  verbose = FALSE
)
}
\arguments{
\item{points}{a vector of points}

\item{swath}{a vector containing the swath of the vehicle
in meters}

\item{distance}{a vector containing the distance traveled
by the vehicle in meters}

\item{angle}{a vector containing the angle of the
vehicle's trajectory. If not supplied, the function
will attempt to estimate the trajectory angle using the
geographical information contained in the georeferenced
points/}

\item{cores}{the number of cores used in the operation}

\item{verbose}{whether to print operation details}
}
\value{
an sf object
}
\description{
Make vehicular polygons for yield monitor
  observations
}
\details{
This function will create vehicular polygons
  based on the distance between points, angle of the
  vehicle's trajectory, and swath.
}
\examples{
\donttest{
## for examples, see vignette pacu
}

}
\author{
Caio dos Santos and Fernando Miguez
}
