% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.r
\name{read_paf}
\alias{read_paf}
\title{Read a genomic alignment in PAF format}
\usage{
read_paf(file_name, tibble = FALSE, include_tags = TRUE)
}
\arguments{
\item{file_name}{Path to the .paf file}

\item{tibble}{logical  If TRUE, the genomic alignments are returned as
a tidy \code{tbl_df}}

\item{include_tags}{logical if TRUE (default) read additional information
about each alignment encoded as PAF tags. Setting this to FALSE will speed up
parsing of paf alignments, specially those with large CIGAR strings/}
}
\value{
Either a \code{pafr} object, which acts as a \code{data.frame}, or a
\code{tbl_df} containing information on genomic alignments. The contents of
this table are described in detail in the pafr package vingette.
}
\description{
See the package vignette for detailed information on the file format and its
representation as an R object.
}
\examples{
ali <- read_paf( system.file("extdata", "fungi.paf", package="pafr") )
ali
}
