% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p1app4p2.R
\name{p2ViewPagodaApp}
\alias{p2ViewPagodaApp}
\title{p2ViewPagodaApp R6 class}
\description{
Modified 'PAGODA1' app (from 'SCDE') for browsing 'pagoda2' results. 
Refer to 'ViewPagodaAppOld' and 'make.pagoda.app()' in 'SCDE'
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{results}}{Result object returned by \code{scde.expression.difference()} (default=NULL). Note to browse group posterior levels, use \code{return.posteriors = TRUE} in the \code{scde.expression.difference()} call.}

\item{\code{type}}{Either 'counts' or a name of a 'reduction' in the 'Pagoda2' object}

\item{\code{genes}}{List of genes to display in the Detailed clustering panel (default=list())}

\item{\code{batch}}{Any batch or other known confounders to be included in the visualization as a column color track (default=NULL)}

\item{\code{pathways}}{character vector Pathway or gene names (default=NULL)}

\item{\code{name}}{App name (needs to be altered only if adding more than one app to the server using the 'server' parameter) (default=NULL)}

\item{\code{trim}}{Trim quantity used for Winsorization for visualization}

\item{\code{embedding}}{Embedding information (default=NULL)}

\item{\code{veloinfo}}{Velocity information (default=NULL)}

\item{\code{goenv}}{environment mapping pathways to genes (default=NULL)}

\item{\code{renv}}{Global environment (default=NULL)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{p2ViewPagodaApp$new()}}
\item \href{#method-getgenecldata}{\code{p2ViewPagodaApp$getgenecldata()}}
\item \href{#method-call}{\code{p2ViewPagodaApp$call()}}
\item \href{#method-clone}{\code{p2ViewPagodaApp$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize p2ViewPagodaApp class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{p2ViewPagodaApp$new(
  results,
  pathways,
  genes,
  goenv,
  batch = NULL,
  name = "pathway overdispersion",
  trim = 1.1/nrow(p2$counts),
  embedding = NULL,
  type,
  veloinfo = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{results}}{Result object returned by \code{scde.expression.difference()}. Note to browse group posterior levels, use \code{return.posteriors = TRUE} in the \code{scde.expression.difference()} call.}

\item{\code{pathways}}{character vector Pathway or gene names (default=NULL)}

\item{\code{genes}}{list Genes to display in the Detailed clustering panel (default=list())}

\item{\code{goenv}}{Environment mapping pathways to genes (default=NULL)}

\item{\code{batch}}{Any batch or other known confounders to be included in the visualization as a column color track (default=NULL)}

\item{\code{name}}{string App name (needs to be altered only if adding more than one app to the server using the 'server' parameter) (default="pathway overdispersion")}

\item{\code{trim}}{numeric Trim quantity used for Winsorization for visualization (default=1.1/nrow(p2$counts) whereby the 'counts' from the 'Pagoda2' object is the gene count matrix, normalized on total counts (default=NULL)}

\item{\code{embedding}}{Embedding information (default=NULL)}

\item{\code{type}}{Either 'counts' or a name of a 'reduction' in the 'pagoda2' object}

\item{\code{veloinfo}}{Velocity information (default=NULL)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
new 'p2ViewPagodaApp' object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getgenecldata"></a>}}
\if{latex}{\out{\hypertarget{method-getgenecldata}{}}}
\subsection{Method \code{getgenecldata()}}{
Helper function to get the heatmap data for a given set of genes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{p2ViewPagodaApp$getgenecldata(genes = NULL, gcl = NULL, ltrim = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genes}}{character vector Gene names (default=NULL)}

\item{\code{gcl}}{pathway or gene-weighted PCA (default=NULL). If NULL, uses tp2c.view.pathways(self$genes, self$results$p2, goenv=goenv, vhc=self$results$hvc, plot=FALSE, trim=ltrim, n.genes=Inf).}

\item{\code{ltrim}}{numeric Winsorization trim that should be applied (default=0)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
heatmap data for a given set of genes
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-call"></a>}}
\if{latex}{\out{\hypertarget{method-call}{}}}
\subsection{Method \code{call()}}{
Call Rook application. Using client-side ExtJS framework and Inchlib HTML5 canvas libraries to create the graphical user interface for PAGODA
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{p2ViewPagodaApp$call(env)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{env}}{The environment argument is a true R environment object which the application is free to modify. Please see the Rook documentation for more details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
modified 'PAGODA1' app
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{p2ViewPagodaApp$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
