% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{phylo.spindles}
\alias{phylo.spindles}
\title{Plots a phylogenetic tree with spindle-diagrams, optimized for showing taxonomic diversity.}
\usage{
phylo.spindles(
  phylo0,
  occ,
  stat = divdistr_,
  prefix = "sptab_",
  pos = NULL,
  ages = NULL,
  xlimits = NULL,
  res = 1,
  weights = 1,
  dscale = 0.002,
  col = add.alpha("black"),
  fill = col,
  lwd = 1,
  lty = 1,
  cex.txt = 1,
  col.txt = add.alpha(col, 1),
  axis = TRUE,
  labels = TRUE,
  txt.y = 0.5,
  txt.x = NULL,
  adj.x = 0,
  add = FALSE,
  tbmar = 0.2,
  smooth = 0,
  italicize = character()
)
}
\arguments{
\item{phylo0}{A time-calibrated phylogenetic tree to plot with spindle diagrams, or a character vector of taxonomic names for which to plot spindle diagrams.}

\item{occ}{Either a list()-object containing taxon-range tables for plotting diversity, or a matrix() or data.frame()-object that contains numerical plotting statistics. If the latter is provided, the default use of divdistr_() is overridden and the function will look for a column named "x" and columns matching the phylogeny tip.labels to plot the spindles.}

\item{stat}{Plotting statistic to be passed on to viol(). Defaults to use divdistr_().}

\item{prefix}{Prefix for taxon-range tables in occ. Defaults to "sptab_"}

\item{pos}{Position at which to draw spindles. If NULL (default), then spindles are drawn at c(1:n) where n is the number of taxa in phylo0.}

\item{ages}{Optional matrix with lower and upper age limits for each spindle, formatted like the output of tree.ages() (most commonly the same calibration matrix used to time-calibrate the tree)}

\item{xlimits}{Limits for plotting the on the x axis.}

\item{res}{Temporal resolution of diversity estimation (if occ is a matrix or data.frame containing plotting statistics, this is ignored)}

\item{weights}{Weights for diversity estimation. Must have the same length as the range of xlimits divided by res. For details, see divdistr_()}

\item{dscale}{Scale value of the spindles on the y axis. Should be adjusted manually to optimize visibility of results.}

\item{col}{Color to use for the border of the plotted spindles}

\item{fill}{Color to use for the fill of the plotted spindles. Defaults to col.}

\item{lwd}{Line width for the plotted spindles.}

\item{lty}{Line type for the plotted spindles.}

\item{cex.txt}{Adjustment for tip label text size}

\item{col.txt}{tip label text color, defaults to be same as col, but with no transparency}

\item{axis}{Logical indicating whether to plot (temporal) x axis (defaults to TRUE)}

\item{labels}{Logical indicating whether to plot tip labels of phylogeny (defaults to TRUE)}

\item{txt.y}{y axis alignment of tip labels}

\item{txt.x}{x coordinates for plotting tip labels. Can be a single value applicable to all labels, or a vector of the same length as phylo0$tip.label}

\item{adj.x}{Numeric value giving alignment on x axis, defaults to 0 (left-aligned) but can also be 0.5 (centered) or 1 (right-aligned).}

\item{add}{Logical indicating whether to add to an existing plot, in which case only the spindles are plotted on top of an existing phylogeny, or not, in which case the phylogeny is plotted along with the spindles.}

\item{tbmar}{Top and bottom margin around the plot. Numeric of either length 1 or 2}

\item{smooth}{Smoothing parameter to be passed on to divdistr_()}

\item{italicize}{Character or numeric vector specifying which labels to italicize, if any.}
}
\value{
A plotted phylogeny with spindle diagrams plotted at each of its terminal branches.
}
\description{
Plots a phylogenetic tree with spindle-diagrams, optimized for showing taxonomic diversity.
}
\details{
The phylo.spindles() function allows the plotting of a phylogeny with spindle diagrams at each of its terminal branches. Various data can be represented (e.g. disparity, abundance, various diversity measures, such as those output by the divDyn package, etc.) depending on the settings for occ and stat, but the function is optimized to plot the results of divdistr_() and does so by default.
If another function is used as an argument to stat, it has to be able to take the sequence resulting from xlimits and res as its first, and occ as its 'table' argument and return a vector of the same length as range(xlimits)/res to be plotted. If occ is a list() object containing multiple dataframes, occurrence datasets or taxon range tables are automatically converted to work with abdistr_() or divdistr_() respectively (if the plot contains a phylogeny). If occ is a matrix or data.frame, the x values must already be converted (e.g. using tsconv()) to match the phylogeny.
}
\examples{
data(archosauria)
data(tree_archosauria)
data(ages_archosauria)
data(diversity_table)
phylo.spindles(tree_archosauria,occ=archosauria,dscale=0.005,ages=ages_archosauria,txt.x=66)
phylo.spindles(tree_archosauria,occ=diversity_table,dscale=0.005,ages=ages_archosauria,txt.x=66)
}
