% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{ts.stages}
\alias{ts.stages}
\title{Add a horizontal, stage-level phanerozoic timescale to any plot, especially calibrated phylogenies plotted with ape.}
\usage{
ts.stages(
  phylo = NULL,
  alpha = 1,
  names = FALSE,
  col.txt = NULL,
  border = NA,
  ylim = NULL,
  adj.txt = c(0.5, 0.5),
  txt.y = mean,
  bw = FALSE,
  update = NULL
)
}
\arguments{
\item{phylo}{Optional (calibrated) phylogeny to which to add timescale. If phylogeny is provided, the $root.time variable is used to convert ages so that the time scale will fit the phylogeny.}

\item{alpha}{Opacity value to use for the fill of the time scale}

\item{names}{Logical indicating whether to plot stage names (defaults to FALSE)}

\item{col.txt}{Color(s) to use for labels.}

\item{border}{Color to use for the border of the timescale}

\item{ylim}{Setting for height of the timescale. Can either be one single value giving the height of the timescale, in which case the function attempts to use the lower limit of the current plot as the lower margin, or a vector of length 2 containing the lower and upper limits of the timescale.}

\item{adj.txt}{Numeric vector of length==2 giving horizontal and vertical label alignment (defaults to centered, i.e. 0.5 for both values)}

\item{txt.y}{Function to use to determine the vertical text position (defaults to mean, i.e. centered)}

\item{bw}{Logical whether to plot in black and white (defaults to FALSE). If TRUE, time scale is drawn with a white background}

\item{update}{Character string giving the filename of a .csv table for providing an updated timescale. If provided, the values for plotting the time scale are taken from the csv file instead of the internally provided values. Table must have columns named stage, bottom, top and col, giving the stage names, start time in ma, end time in ma and a valid color value, respectively.}
}
\value{
Plots a timescale on the currently active plot.
}
\description{
Add a horizontal, stage-level phanerozoic timescale to any plot, especially calibrated phylogenies plotted with ape.
}
\examples{
data(tree_archosauria)
ape::plot.phylo(tree_archosauria)
ts.stages(tree_archosauria, alpha=0.7)
ts.periods(tree_archosauria, alpha=0)
}
