% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexModels.R
\name{fit.sgs}
\alias{fit.sgs}
\title{Fit a model of trait evolution with a protracted punctuation.}
\usage{
fit.sgs(
  y,
  minb = 7,
  oshare = TRUE,
  pool = TRUE,
  silent = FALSE,
  hess = FALSE,
  meth = "L-BFGS-B",
  model = "GRW"
)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{minb}{minimum number of populations within each segment}

\item{oshare}{logical, if TRUE, variance assumed to be shared (equal) across segments}

\item{pool}{if TRUE, sample variances are substituted with their pooled estimate}

\item{silent}{logical, if TRUE, progress updates are suppressed}

\item{hess}{if TRUE, standard errors computed from the Hessian matrix are returned}

\item{meth}{optimization method, passes to \code{optim}}

\item{model}{type of random walk: \code{"URW"}, unbiased random walk, or \code{"GRW"},
a general (directional) random walk}
}
\value{
a \code{paleoTSfit} object
}
\description{
This function fits a model of punctuated change that is is protracted enough that
it is captured by multiple transitional populations.  Trait evolution starts in stasis,
shifts to a general random walk, and then shifts back into stasis.
}
\examples{
\dontrun{
x <- sim.sgs(ns = c(15, 15, 15))  # default values OK
w <- fit.sgs(x, minb = 10)  # increase minb so example takes less time; not recommended!
plot(x)
abline(v = c(16, 31), lwd = 3)  # actual shifts
abline(v = c(w$parameters[6:7]), lwd = 2, lty = 3, col = "red")  # inferred shifts
}
}
\seealso{
\code{\link{fitGpunc}}
}
