% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_taxa}
\alias{pbdb_taxa}
\title{Get information about multiple taxonomic names}
\usage{
pbdb_taxa(...)
}
\arguments{
\item{...}{Arguments passed to the API. See all available arguments
at \url{https://paleobiodb.org/data1.2/taxa/list}.
\itemize{
\item \code{name}: Returns information about the most fundamental taxonomic
name matching this string.  The \% and _ characters may be used as
wildcards.
\item \code{id}: Return information about the taxonomic name corresponding
to this identifier. You may not specify both \code{name} and \code{id} in
the same query.
\item \code{show}: Show extra variables. Some examples include: \code{"attr"} the
attribution of this taxon (author and year); \code{"app"} the age of
first and last appearance of this taxon from the occurrences
recorded in this database; \code{"size"} the number of subtaxa
appearing in this database.
\item \code{rel}: Set \code{rel = "synonyms"} to select all synonyms of the base
taxon or taxa; \code{rel = "children"} to select the taxa immediately
contained within the base taxon or taxa; \code{rel = "common"} to
select the most specific taxon that contains all of the base
taxa.
\item \code{extant}: Logical indicating whether to select only extant or
non-extant taxa.
}}
}
\value{
A data frame with information from a list of taxa.
}
\description{
Returns information about multiple taxonomic names.  This function
can be used to query for all of the children or parents of a given
taxon, among other operations.
}
\examples{
\dontrun{
  pbdb_taxa(name = "Canidae", rel = "all_parents", vocab = "pbdb",
            show = c("attr", "app", "size", "class"))
  pbdb_taxa(id = c(10, 11), vocab = "pbdb",
            show = c("attr", "app", "size", "class"))
  pbdb_taxa(
    id = c(10, 11), vocab = "pbdb",
    show = c("attr", "app", "size", "class"), rel = "common"
  )
}
}
