% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-list.R
\name{pandoc_list_abbreviations}
\alias{pandoc_list_abbreviations}
\title{List system default abbreviations}
\usage{
pandoc_list_abbreviations(version = "default")
}
\arguments{
\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
a character version of system default abbreviation known by Pandoc
}
\description{
Pandoc uses this list in the Markdown reader. Strings found in this list will
be followed by a non-breaking space, and the period will not produce
sentence-ending space in formats like LaTeX. The strings may not contain
spaces.
}
\details{
This correspond to the option \href{https://pandoc.org/MANUAL.html#option--abbreviations}{\code{--abbreviations} as CLI flag}.
}
\examples{
\dontshow{if (pandoc::pandoc_available("2.0")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pandoc_list_abbreviations()
\dontshow{\}) # examplesIf}
\dontshow{if (pandoc::pandoc_is_installed("2.11.4")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# check abbreviations available in a specific Pandoc's version
pandoc_list_abbreviations("2.11.4")
\dontshow{\}) # examplesIf}
}
