% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panelPomp_methods.R
\docType{methods}
\name{panelPomp_methods}
\alias{panelPomp_methods}
\alias{coef,panelPomp-method}
\alias{coef<-,panelPomp-method}
\alias{length,panelPomp-method}
\alias{names,panelPomp-method}
\alias{pparams,panelPomp-method}
\alias{pParams}
\alias{print,panelPomp-method}
\alias{show,panelPomp-method}
\alias{unitobjects,panelPomp-method}
\alias{window,panelPomp-method}
\alias{[,panelPomp-method}
\alias{[[,panelPomp-method}
\title{Manipulating \code{panelPomp} objects}
\usage{
\S4method{coef}{panelPomp}(object)

\S4method{coef}{panelPomp}(object, ...) <- value

\S4method{length}{panelPomp}(x)

\S4method{names}{panelPomp}(x)

\S4method{pparams}{panelPomp}(object)

pParams(value)

\S4method{print}{panelPomp}(x, ...)

\S4method{show}{panelPomp}(object)

\S4method{unitobjects}{panelPomp}(object)

\S4method{window}{panelPomp}(x, start, end)

\S4method{[}{panelPomp}(x, i)

\S4method{[[}{panelPomp}(x, i)
}
\arguments{
\item{object, x}{An object of class \code{panelPomp} or inheriting class
\code{panelPomp}.}

\item{...}{....}

\item{value}{value to be assigned.}

\item{start, end}{position in original \code{times(pomp)} at which to start.}

\item{i}{unit index (indices) or name (names).}
}
\value{
\code{coef()} returns a \code{numeric} vector.

\code{length()} returns an \code{integer}.

\code{names()} returns a \code{character} vector.

\pparamsReturn

\code{pParams()} returns a \code{list} with the model parameters in list form.

\unitobjectsReturn

\code{window()} returns a \code{panelPomp} object with adjusted times.

\code{`[`} returns a \code{panelPomp} object.

\code{`[[`} returns a \code{pomp} object.
}
\description{
Tools for manipulating \code{panelPomp} objects.
}
\section{Methods}{

\describe{
  \item{coef}{Extracts coefficients of \code{panelPomp} objects.}
  \item{coef<-}{Assign coefficients to \code{panelPomp} objects.}
  \item{length}{Count the number of units in \code{panelPomp} objects.}
  \item{names}{Get the unit names of \code{panelPomp} objects.}
  \item{pparams}{Extracts coefficients from \code{panelPomp} objects in list form.}
  \item{pParams}{Converts panel coefficients from vector form to list form.}
  \item{window}{Subset \code{panelPomp} objects by changing start time and
  end time.}
  \item{\code{[]}}{Take a subset of units.}
  \item{\code{[[]]}}{Select the pomp object for a single unit.}
  }
}

\examples{
## access and manipulate model parameters and other features
prw <- panelRandomWalk()
coef(prw)
# replace coefficients
coef(prw) <- c(sigmaX=2,coef(prw)[-1])
coef(prw)
length(prw)
names(prw)
# extract parameters in list form
pparams(prw)
# convert vector-form parameters to list-form parameters
pParams(coef(prw))
## summaries of objects
print(prw)
show(prw)
## access underlying pomp objects
unitobjects(prw)
## select windows of time
window(prw,start=2,end=4)
## subsetting panelPomp objects
prw[1] # panelPomp of 1 unit (first unit of prw)
prw[[2]] # pomp object corresponding to unit 2 of prw
}
\seealso{
Other panelPomp methods: 
\code{\link{as}()}
}
\author{
Carles \Breto, Aaron A. King.
}
\concept{panelPomp methods}
