% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{nekd}
\alias{nekd}
\title{The naive kernel density estimation}
\usage{
nekd(
  data,
  acov_order = 0,
  acor_order = 1,
  mean_bw = NULL,
  acov_bw = NULL,
  acor_bw = NULL
)
}
\arguments{
\item{data}{A matrix of panel data.
Each row corresponds to individual time series.}

\item{acov_order}{A non-negative integer of the order of autocovariance.
Default is 0.}

\item{acor_order}{A positive integer of the order of autocorrelation.
Default is 1.}

\item{mean_bw}{A scalar of bandwidth used for the estimation of
the denisty of mean.
Default is NULL, and the plug-in bandwidth is used.}

\item{acov_bw}{A scalar of bandwidth used for the estimation of
the denisty of autocovariance.
Default is NULL, and the plug-in bandwidth is used.}

\item{acor_bw}{A scalar of bandwidth used for the estimation of
the denisty of autocorrelation.
Default is NULL, and the plug-in bandwidth is used.}
}
\value{
A list that contains the following elements:
\item{mean}{A plot of the corresponding density}
\item{acov}{A plot of the corresponding density}
\item{acor}{A plot of the corresponding density}
\item{mean_func}{A function that returns the corresponding density}
\item{acov_func}{A function that returns the corresponding density}
\item{acor_func}{A function that returns the corresponding density}
\item{bandwidth}{A Vector of the bandwidths}
\item{quantity}{A matrix of the estimated heterogeneous quantities}
\item{acov_order}{The order of autocovariance}
\item{acor_order}{The order of autocorrelation}
\item{N}{The number of cross-sectional units}
\item{S}{The length of time series}
}
\description{
The `nekd()` function enables to implement the naive kernel density
estimation without bias correction for the heterogeneous mean,
the autocovariance, and the autocorrelation.
The method is developed by Okui and Yanagi (2020).
For more details, see the package vignette with `vignette("panelhetero")`.
}
\examples{
data <- panelhetero::simulation(N = 300, S = 50)
panelhetero::nekd(data = data)

}
\references{
Okui, R. and Yanagi, T., 2020.
Kernel estimation for panel data with heterogeneous dynamics.
The Econometrics Journal, 23(1), pp.156-175.
}
