% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_catalog_search.R
\name{ps1_crossmatch}
\alias{ps1_crossmatch}
\title{Do a cross-match with PS1 catalog}
\usage{
ps1_crossmatch(
  ra,
  dec,
  r_arcmin = 0.05,
  table = c("mean", "stack", "detection"),
  release = c("dr2", "dr1"),
  verbose = FALSE
)
}
\arguments{
\item{ra}{(degrees) numeric vector of J2000 Right Ascension}

\item{dec}{(degrees) numeric vector of J2000 Declination}

\item{r_arcmin}{(arcmins) Search radius (<= 30 arcmins)}

\item{table}{"mean"(default), "stack", or "detection"}

\item{release}{"dr1" or "dr2"(default)}

\item{verbose}{print info about request}
}
\value{
data.frame
}
\description{
Do a cross-match with PS1 catalog
}
\examples{
\dontrun{
ps1_crossmatch(ra = c(268.70342, 168.87258), dec = c(71.54292, 60.75153))
}
}
