% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_num.R
\name{apa_num}
\alias{apa_num}
\alias{printnum}
\alias{print_num}
\alias{apa_num.default}
\alias{apa_num.list}
\alias{apa_num.integer}
\alias{apa_num.numeric}
\alias{apa_num.data.frame}
\alias{apa_num.matrix}
\alias{apa_num.tiny_labelled}
\title{Typeset Numerical Values for Printing and Reporting}
\usage{
apa_num(x, ...)

printnum(x, ...)

print_num(x, ...)

\method{apa_num}{default}(x, na_string = getOption("papaja.na_string"), ...)

\method{apa_num}{list}(x, ...)

\method{apa_num}{integer}(
  x,
  numerals = TRUE,
  capitalize = FALSE,
  zero_string = "no",
  na_string = getOption("papaja.na_string"),
  ...
)

\method{apa_num}{numeric}(
  x,
  gt1 = TRUE,
  zero = TRUE,
  na_string = getOption("papaja.na_string"),
  use_math = TRUE,
  add_equals = FALSE,
  ...
)

\method{apa_num}{data.frame}(x, margin = 2, ...)

\method{apa_num}{matrix}(x, margin = 2, ...)

\method{apa_num}{tiny_labelled}(x, ...)
}
\arguments{
\item{x}{Can be either a single value, vector, \code{matrix}, \code{data.frame}.}

\item{...}{
  Arguments passed on to \code{\link[base:formatc]{base::formatC}}
  \describe{
    \item{\code{digits}}{the desired number of digits after the decimal
    point (\code{format = "f"}) or \emph{significant} digits
    (\code{format = "g"}, \code{= "e"} or \code{= "fg"}).

    Default: 2 for integer, 4 for real numbers.  If less than 0,
    the C default of 6 digits is used.  If specified as more than 50, 50
    will be used with a warning unless \code{format = "f"} where it is
    limited to typically 324. (Not more than 15--21 digits need be
    accurate, depending on the OS and compiler used.  This limit is
    just a precaution against segfaults in the underlying C runtime.)
  }
    \item{\code{width}}{the total field width; if both \code{digits} and
    \code{width} are unspecified, \code{width} defaults to 1,
    otherwise to \code{digits + 1}.  \code{width = 0} will use
    \code{width = digits}, \code{width < 0} means left
    justify the number in this field (equivalent to \code{flag = "-"}).
    If necessary, the result will have more characters than
    \code{width}.  For character data this is interpreted in characters
    (not bytes nor display width).
  }
    \item{\code{format}}{equal to \code{"d"}  (for integers), \code{"f"},
    \code{"e"}, \code{"E"}, \code{"g"}, \code{"G"}, \code{"fg"} (for
    reals), or \code{"s"} (for strings).  Default is \code{"d"} for
    integers, \code{"g"} for reals.

    \code{"f"} gives numbers in the usual
    \code{xxx.xxx} format;  \code{"e"} and \code{"E"} give \code{n.ddde+nn} or
    \code{n.dddE+nn} (scientific format); \code{"g"} and \code{"G"} put
    \code{x[i]} into scientific format only if it saves space to do so
    \emph{and} drop trailing zeros and decimal point - unless \code{flag}
    contains \code{"#"} which keeps trailing zeros for the \code{"g", "G"}
    formats.

    \code{"fg"} (our own hybrid format) uses fixed format as \code{"f"},
    but \code{digits} as the minimum number of \emph{significant} digits.
    This can lead to quite long result strings, see examples below.  Note
    that unlike \code{\link[base]{signif}} this prints large numbers with
    more significant digits than \code{digits}.  Trailing zeros are
    \emph{dropped} in this format, unless \code{flag} contains
    \code{"#"}.}
    \item{\code{flag}}{for \code{formatC}, a character string giving a
    format modifier as in Kernighan and Ritchie (1988, page 243) or the
    C+99 standard.\describe{
      \item{\code{"0"}}{pads leading zeros;}
      \item{\code{"-"}}{does left adjustment,}
      \item{\code{"+"}}{ensures a sign in all cases, i.e., \code{"+"} for
	positive numbers ,}
      \item{\code{" "}}{if the first character is not a sign, the space
	character \code{" "} will be used instead.}
      \item{\code{"#"}}{specifies \dQuote{an alternative output form},
	specifically depending on \code{format}.}
      \item{\code{"'"}}{on some platform--locale combination, activates
	\dQuote{thousands' grouping} for decimal conversion,}
      \item{\code{"I"}}{in some versions of \file{glibc} allow for integer
	conversion to use the locale's alternative output digits, if any.}
    }
    There can be more than one of these flags, in any order.  Other characters
    used to have no effect for \code{character} formatting, but signal
    an error since \R 3.4.0.
  }
    \item{\code{mode}}{\code{"double"} (or \code{"real"}), \code{"integer"} or
    \code{"character"}.
    Default: Determined from the storage mode of \code{x}.}
    \item{\code{big.mark}}{character; if not empty used as mark between every
    \code{big.interval} decimals \emph{before} (hence \code{big}) the
    decimal point.}
    \item{\code{big.interval}}{see \code{big.mark} above; defaults to 3.}
    \item{\code{small.mark}}{character; if not empty used as mark between every
    \code{small.interval} decimals \emph{after} (hence \code{small}) the
    decimal point.}
    \item{\code{small.interval}}{see \code{small.mark} above; defaults to 5.}
    \item{\code{decimal.mark}}{the character to be used to indicate the numeric
    decimal point.}
    \item{\code{preserve.width}}{string specifying if the string widths should
    be preserved where possible in those cases where marks
    (\code{big.mark} or \code{small.mark}) are added.  \code{"common"},
    the default, corresponds to \code{\link[base]{format}}-like behavior
    whereas \code{"individual"} is the default in
    \code{formatC()}. Value can be abbreviated.}
    \item{\code{zero.print}}{logical, character string or \code{NULL} specifying
    if and how \emph{zeros} should be formatted specially.  Useful for
    pretty printing \sQuote{sparse} objects.}
    \item{\code{drop0trailing}}{logical, indicating if trailing zeros,
    i.e., \code{"0"} \emph{after} the decimal mark, should be removed;
    also drops \code{"e+00"} in exponential formats.  This is simply passed
    to \code{prettyNum()}, see the \sQuote{Details}.}
  }}

\item{na_string}{Character. String to print if any element of \code{x} is \code{NA}.}

\item{numerals}{Logical. Indicates if integers should be converted to words.}

\item{capitalize}{Logical. Indicates if first letter should be capitalized.
Ignored if \code{numerals = TRUE}.}

\item{zero_string}{Character. Word to print if \code{x} is a zero integer.}

\item{gt1}{Logical. Indicates if the statistic can, in principle, have an
absolute value greater than 1. If \code{FALSE}, leading zeros are
omitted.}

\item{zero}{Logical. Indicates if the statistic can, in principle, be 0. If
\code{FALSE}, a string of the form \verb{< 0.001} is returned instead of 0.}

\item{use_math}{Logical. Indicates whether to use \code{$} in the output so that
\code{Inf} or scientific notation is rendered correctly.}

\item{add_equals}{Logical. Indicates if the output string should be
prepended with an \code{=}.}

\item{margin}{Integer. If \code{x} is a \code{matrix} or \code{data.frame}, the function
is applied either across rows (\code{margin = 1}) or columns (\code{margin = 2}).
See \code{\link[=apply]{apply()}}.}
}
\value{
An object of the same class as \code{x} with all numeric values converted
to character.
}
\description{
Converts numerical values to character strings for printing and reporting.
}
\details{
If \code{x} is a vector, all arguments can be vectors according to which each
element of the vector is formatted. Parameters are recycled if length of
\code{x} exceeds the length of the parameter vectors. If \code{x} is a \code{matrix} or
\code{data.frame}, the vectors specify the formatting of either rows or columns
according to the value of \code{margin}.

We recommend to use \code{apa_num()}, rather than \code{printnum()} or \code{print_num()},
which are aliases kept only for backward compatibility.
}
\examples{
apa_num(1/3)
apa_num(1/3, gt1 = FALSE)
apa_num(1/3, digits = 5)

apa_num(0)
apa_num(0, zero = FALSE)
}
\seealso{
\code{\link[=apa_p]{apa_p()}}, \code{\link[=apa_df]{apa_df()}}
}
