% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.r
\name{par_sapply}
\alias{par_sapply}
\title{Run a Task in Parallel}
\usage{
par_sapply(backend = NULL, x, fun, ...)
}
\arguments{
\item{backend}{An object of class \code{\link{Backend}} as returned by the
\code{\link[=start_backend]{start_backend()}} function. It can also be \code{NULL} to run the task
sequentially via \code{\link[base:lapply]{base::sapply()}}. The default value is \code{NULL}.}

\item{x}{A vector (i.e., usually of integers) to pass to the \code{fun} function.}

\item{fun}{A function to apply to each element of \code{x}.}

\item{...}{Additional arguments to pass to the \code{fun} function.}
}
\value{
A vector or list of the same length as \code{x} containing the results of the
\code{fun}. The output format resembles that of \code{\link[base:lapply]{base::sapply()}}.
}
\description{
This function can be used to run a task in parallel. The task is executed in
parallel on the specified backend, similar to \code{\link[parallel:clusterApply]{parallel::parSapply()}}. If
\code{backend = NULL}, the task is executed sequentially using \code{\link[base:lapply]{base::sapply()}}.
See the \strong{Details} section for more information on how this function works.
}
\details{
This function is a wrapper around the developer API of the
\code{\link{parabar}} package. More specifically, this function:
\itemize{
\item Instantiates an appropriate \code{\link{parabar}} context. If the backend
supports progress tracking (i.e., the backend is an instance of
\code{\link{AsyncBackend}}), a progress tracking context (i.e.,
\code{\link{ProgressDecorator}}) is instantiated and used. Otherwise, a
regular context (i.e., \code{\link{Context}}) is instantiated. A regular
context is also used if the progress tracking is disabled via the
\code{\link{Options}} instance.
\item Registers the \code{\link[=Backend]{backend}} with the context.
\item Instantiates and configures the progress bar based on the
\code{\link{Options}} instance in the session \code{\link[base:options]{base::.Options}} list.
\item Executes the task in parallel, and displays a progress bar if appropriate.
}
}
\examples{
\donttest{

# Define a simple task.
task <- function(x) {
    # Perform computations.
    Sys.sleep(0.01)

    # Return the result.
    return(x + 1)
}

# Start an asynchronous backend.
backend <- start_backend(cores = 2, cluster_type = "psock", backend_type = "async")

# Run a task in parallel.
results <- par_sapply(backend, x = 1:300, fun = task)

# Disable progress tracking.
set_option("progress_track", FALSE)

# Run a task in parallel.
results <- par_sapply(backend, x = 1:300, fun = task)

# Enable progress tracking.
set_option("progress_track", TRUE)

# Change the progress bar options.
configure_bar(type = "modern", format = "[:bar] :percent")

# Run a task in parallel.
results <- par_sapply(backend, x = 1:300, fun = task)

# Stop the backend.
stop_backend(backend)

# Start a synchronous backend.
backend <- start_backend(cores = 2, cluster_type = "psock", backend_type = "sync")

# Run a task in parallel.
results <- par_sapply(backend, x = 1:300, fun = task)

# Disable progress tracking to remove the warning that progress is not supported.
set_option("progress_track", FALSE)

# Run a task in parallel.
results <- par_sapply(backend, x = 1:300, fun = task)

# Stop the backend.
stop_backend(backend)

# Run the task using the `base::sapply` (i.e., non-parallel).
results <- par_sapply(NULL, x = 1:300, fun = task)

}

}
\seealso{
\code{\link[=start_backend]{start_backend()}}, \code{\link[=peek]{peek()}}, \code{\link[=export]{export()}},
\code{\link[=evaluate]{evaluate()}}, \code{\link[=clear]{clear()}}, \code{\link[=configure_bar]{configure_bar()}},
\code{\link[=stop_backend]{stop_backend()}}, \code{\link[=set_option]{set_option()}}, \code{\link[=get_option]{get_option()}},
\code{\link{Options}}, and \code{\link{Service}}.
}
