% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_ci.R
\name{format_ci}
\alias{format_ci}
\title{Confidence/Credible Interval (CI) Formatting}
\usage{
format_ci(CI_low, CI_high, ci = 0.95, digits = 2)
}
\arguments{
\item{CI_low}{Lower CI bound.}

\item{CI_high}{Upper CI bound.}

\item{ci}{CI level in percentage.}

\item{digits}{Number of significant digits.}
}
\value{
A formatted string.
}
\description{
Confidence/Credible Interval (CI) Formatting
}
\examples{
format_ci(1.20, 3.57, ci = 0.90)
format_ci(1.20, 3.57, ci = NULL)
format_ci(c(1.205645, 23.4), c(3.57, -1.35), ci = 0.90)
format_ci(c(1.20, NA, NA), c(3.57, -1.35, NA), ci = 0.90)
}
