% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.lm.R
\name{model_parameters.lm}
\alias{model_parameters.lm}
\title{Parameters of (General) Linear Models}
\usage{
\method{model_parameters}{lm}(model, ci = 0.95, standardize = "refit",
  standardize_robust = FALSE, bootstrap = FALSE, iterations = 1000,
  ...)
}
\arguments{
\item{model}{Frequentist regression object.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{standardize}{Add standardized parameters. Can be FALSE or a character indicating the standardization method (see \code{\link{parameters_standardize}}), such as "refit", "2sd", "smart" or "classic". The two formers are based on model refitting using a standardized version of data. It is the most accurate, altough computationnaly heavy (as it must re-fit a second model). The "smart" and "classic" are post-hoc methods, fast, but inaccurate (especially if the model includes interactions).}

\item{standardize_robust}{Robust standardization. See \code{\link{parameters_standardize}}.}

\item{bootstrap}{Should estimates be based on bootsrapped model? If TRUE, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply.}

\item{iterations}{The number of bootstrap replicates. This only apply in the case of bootsrapped frequentist models.}

\item{...}{Arguments passed to or from other methods (e.g., to \link[=standardize.lm]{standardize}).}
}
\value{
A data.frame of indices related to the model's parameters.
}
\description{
Extract and compute indices and measures to describe parameters of (general) linear models (GLMs).
}
\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)

model_parameters(model, standardize = "refit")
model_parameters(model, bootstrap = TRUE)

model <- glm(vs ~ wt + cyl, data = mtcars, family = "binomial")
model_parameters(model)
}
