% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principal_components.R
\name{principal_components}
\alias{principal_components}
\alias{PCA}
\title{Principal Component Analysis (PCA)}
\usage{
principal_components(x, n = NULL, rotation = "none", sort = FALSE,
  threshold = NULL, standardize = TRUE, ...)

PCA(x, n = NULL, rotation = "none", sort = FALSE, threshold = NULL,
  standardize = TRUE, ...)
}
\arguments{
\item{x}{A dataframe.}

\item{n}{Number of components to extract. If \code{n = NULL}, the number of components is selected through \code{\link{n_factors}}.}

\item{rotation}{If not "none", the PCA will be computed using the \pkg{psych} package. Possible options include \code{"varimax"}, \code{"quartimax"}, \code{"promax"}, \code{"oblimin"}, \code{"simplimax"}, and \code{"cluster"}. See \code{\link[psych]{fa}} for details.}

\item{sort}{Sort the loadings.}

\item{threshold}{A value between 0 and 1 indicates which (absolute) values from the loadings should be removed. Can also be "max", in which case it will only display the maximum loading per veriable (the most simple structure).}

\item{standardize}{A logical value indicating whether the variables should be standardized (centred and scaled) to have unit variance before the analysis takes place (in general, such scaling is advisable).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data.frame of loadings.
}
\description{
This function performs a principal component analysis (PCA) and returns the loadings (of the unrotated matrix) as dataframe.
}
\details{
\itemize{
   \item \strong{Complexity} (Hoffman's, 1978; Pettersson and Turkheimer, 2010) represents the number of latent components needed to account for the observed variables. Whereas a perfect simple structure solution has a complexity of 1 in that each item would only load on one factor, a solution with evenly distributed items has a complexity greater than 1.
}
}
\note{
There is a \code{summary()}-method that prints the Eigenvalues and (explained) variance for each extracted component.
}
\examples{
library(parameters)

principal_components(mtcars[, 1:7], n = "all", threshold = 0.2)
principal_components(mtcars[, 1:7], n = 2, rotation = "oblimin", threshold = "max", sort = TRUE)

pca <- principal_components(mtcars[, 1:5], n = 2)
summary(pca)
predict(pca)
\donttest{
# Automated number of components
principal_components(mtcars[, 1:4])
}

}
\references{
\itemize{
  \item Pettersson, E., & Turkheimer, E. (2010). Item selection, evaluation, and simple structure in personality data. Journal of research in personality, 44(4), 407-420.
}
}
