% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_cplm.R
\name{model_parameters.zcpglm}
\alias{model_parameters.zcpglm}
\title{Parameters from Zero-Inflated Models}
\usage{
\method{model_parameters}{zcpglm}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  component = c("all", "conditional", "zi", "zero_inflated"),
  standardize = NULL,
  exponentiate = FALSE,
  p_adjust = NULL,
  keep = NULL,
  drop = NULL,
  parameters = keep,
  summary = getOption("parameters_summary", FALSE),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A model with zero-inflation component.}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).}

\item{bootstrap}{Should estimates be based on bootstrapped model? If
\code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply (see also
\code{\link[=bootstrap_parameters]{bootstrap_parameters()}}).}

\item{iterations}{The number of bootstrap replicates. This only apply in the
case of bootstrapped frequentist models.}

\item{component}{Model component for which parameters should be shown. May be
one of \code{"conditional"}, \code{"precision"} (\strong{betareg}),
\code{"scale"} (\strong{ordinal}), \code{"extra"} (\strong{glmx}),
\code{"marginal"} (\strong{mfx}), \code{"conditional"} or \code{"full"} (for
\code{MuMIn::model.avg()}) or \code{"all"}.}

\item{standardize}{The method used for standardizing the parameters. Can be
\code{NULL} (default; no standardization), \code{"refit"} (for re-fitting the model
on standardized data) or one of \code{"basic"}, \code{"posthoc"}, \code{"smart"},
\code{"pseudo"}. See 'Details' in \code{\link[=standardize_parameters]{standardize_parameters()}}.
\strong{Important:}
\itemize{
\item The \code{"refit"} method does \emph{not} standardized categorical predictors (i.e.
factors), which may be a different behaviour compared to other R packages
(such as \strong{lm.beta}) or other software packages (like SPSS). to mimic
such behaviours, either use \code{standardize="basic"} or standardize the data
with \code{datawizard::standardize(force=TRUE)} \emph{before} fitting the model.
\item For mixed models, when using methods other than \code{"refit"}, only the fixed
effects will be returned.
\item Robust estimation (i.e., \code{vcov} set to a value other than \code{NULL}) of standardized parameters only
works when \code{standardize="refit"}.
}}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
the coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log
or logit links. \strong{Note:} Delta-method standard errors are also
computed (by multiplying the standard errors by the transformed
coefficients). This is to mimic behaviour of other software packages, such
as Stata, but these standard errors poorly estimate uncertainty for the
transformed coefficient. The transformed confidence interval more clearly
captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients
from non-Gaussian families.}

\item{p_adjust}{Character vector, if not \code{NULL}, indicates the method to
adjust p-values. See \code{\link[stats:p.adjust]{stats::p.adjust()}} for details. Further
possible adjustment methods are \code{"tukey"}, \code{"scheffe"},
\code{"sidak"} and \code{"none"} to explicitly disable adjustment for
\code{emmGrid} objects (from \strong{emmeans}).}

\item{keep}{Character containing a regular expression pattern that
describes the parameters that should be included (for \code{keep}) or excluded
(for \code{drop}) in the returned data frame. \code{keep} may also be a
named list of regular expressions. All non-matching parameters will be
removed from the output. If \code{keep} is a character vector, every parameter
name in the \emph{"Parameter"} column that matches the regular expression in
\code{keep} will be selected from the returned data frame (and vice versa,
all parameter names matching \code{drop} will be excluded). Furthermore, if
\code{keep} has more than one element, these will be merged with an \code{OR}
operator into a regular expression pattern like this: \code{"(one|two|three)"}.
If \code{keep} is a named list of regular expression patterns, the names of the
list-element should equal the column name where selection should be
applied. This is useful for model objects where \code{model_parameters()}
returns multiple columns with parameter components, like in
\code{\link[=model_parameters.lavaan]{model_parameters.lavaan()}}. Note that the regular expression pattern
should match the parameter names as they are stored in the returned data
frame, which can be different from how they are printed. Inspect the
\verb{$Parameter} column of the parameters table to get the exact parameter
names.}

\item{drop}{See \code{keep}.}

\item{parameters}{Deprecated, alias for \code{keep}.}

\item{summary}{Logical, if \code{TRUE}, prints summary information about the
model (model formula, number of observations, residual standard deviation
and more).}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods. For instance, when
\code{bootstrap = TRUE}, arguments like \code{type} or \code{parallel} are
passed down to \code{bootstrap_model()}, and arguments like \code{ci_method}
are passed down to \code{\link[bayestestR:describe_posterior]{bayestestR::describe_posterior()}}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters from zero-inflated models (from packages like \strong{pscl},
\strong{cplm} or \strong{countreg}).
}
\examples{
library(parameters)
if (require("pscl")) {
  data("bioChemists")
  model <- zeroinfl(art ~ fem + mar + kid5 + ment | kid5 + phd, data = bioChemists)
  model_parameters(model)
}
}
\seealso{
\code{\link[insight:standardize_names]{insight::standardize_names()}} to rename
columns into a consistent, standardized naming scheme.
}
