% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sheet.R, R/write_sheet.R
\name{read_sheet}
\alias{read_sheet}
\alias{write_sheet}
\title{Read/Write sheets (automatically detect the file type and work accordingly)}
\usage{
read_sheet(
  x,
  id_column,
  start_row = 1,
  sheet = 1,
  ext,
  header = TRUE,
  verbose = FALSE,
  ...
)

write_sheet(x, file, ext, type = "", ...)
}
\arguments{
\item{x}{read: path to a file, to be read. write: a data.frame}

\item{id_column}{all rows which have this column as blank are skipped. See details.}

\item{start_row}{supplied to read.xlsx}

\item{sheet}{supplied to read.xlsx, index or name of the sheet to be read from excel file. See \link[openxlsx]{read.xlsx}}

\item{ext}{determined using file extension. Specifying will override}

\item{header}{first line is header? See \link{read.table}}

\item{verbose}{verbosity level.}

\item{...}{passed onto read.xlsx of openxlsx, read.table or read.csv2 depending on the file type.}

\item{file}{write: output file name.}

\item{type}{in case of writing an xlsx file, should the data.frame to written as excel 'table'. ['table']}
}
\description{
Read/Write sheets (automatically detect the file type and work accordingly)

write_sheet requires version 0.3.1.

\itemize{
\item \strong{tsv, txt, conf, def}: assumed to be tab-delimited
\item \strong{csv}: assumed to be comma delimited
\item \strong{xlsx}: microsoft excel, uses openxlsx to read the sheet.
  Also, it removes extra columns which often creep into excel files.
}
}
\details{
\strong{Note: for excel sheets}:
\itemize{
  \item If \code{id_column} is missing, default if first column
  \item If \code{sheet} is missing, it automatically reads the first sheet
}

\strong{Some important default values for tsv and csv files}:

\code{stringsAsFactors = FALSE,comment.char = '#', strip.white=TRUE, blank.lines.skip=TRUE}
}
\examples{

## read a excel sheet
sheet = read_sheet(system.file("extdata/example.xlsx", package = "params"))

## read a comma separated sheet
csv = read_sheet(system.file("extdata/example.csv", package = "params"))

## read a tab separate sheet
tsv = read_sheet(system.file("extdata/example.tsv", package = "params"))


# write sheets -------

\dontrun{
# throws a R CMD check note - don't run
## write a comma separated sheet
write_sheet(sheet, "example.csv")

## write a tab separated sheet
write_sheet(sheet, "example.tsv")

## write an excel separated sheet
write_sheet(sheet, "example.xlsx")
}

}
