% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_basic.R
\name{succeed}
\alias{succeed}
\alias{fail}
\title{The most basic parsers}
\usage{
succeed(left)

fail(lnr = LNR())
}
\arguments{
\item{left}{any R-object constructed from a parsed vector.}

\item{lnr}{integer. The line number (element number) at which the fail
occurs}
}
\value{
A list. \code{succeed()} returns a list with two elements named \code{L} and
\code{R}. \code{fail()} returns a \code{marker} object which is basically an empty list
with a line number \code{n} as attribute. It is printed as the icon \verb{[]},
see \code{\link[=print.marker]{print.marker()}}. Note that \code{n} will only correctly represent the line
number of failure when a parser is wrapped in the \code{\link[=reporter]{reporter()}} function.
}
\description{
These are the most basic constructors of a parser, but they are important
cogs of the parser machinery. The \code{succeed} parser always succeeds, without
consuming any input, whereas the \code{fail} parser always fails.
}
\details{
The \code{succeed} parser constructs a \code{list} object with a 'left' or \code{L}-element
that contains the parser result of the consumed part of the input vector and
the 'right' or \code{R}-element that contains the unconsumed part of the vector.
Since the outcome of succeed does not depend on its input, its result value
must be pre-determined, so it is included as a parameter.

While \code{succeed} never fails, \code{fail} always does, regardless of the input
vector. It returns the empty list \code{list()} to signal this fact.
}
\section{Pseudocode}{

\preformatted{
succeed(y)(x): [L=[y],R=[x]]
fail()(x):     []
}

where \verb{[L=[y],R=[x]]} is a named list with lists \verb{[y]} and \verb{[x]} as elements
and \verb{[]} is an empty list.
}

\section{Note}{

It is very unlikely that you will ever have to use these functions when
constructing parsers.
}

\examples{
succeed("A")("abc")
succeed(data.frame(title="Keisri hull", author="Jaan Kross"))(c("Unconsumed","text"))

fail()("abc")

}
