% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_to_parquet.R
\name{table_to_parquet}
\alias{table_to_parquet}
\title{Convert an input file to parquet format}
\usage{
table_to_parquet(
  path_to_table,
  path_to_parquet,
  by_chunk = FALSE,
  chunk_size,
  skip = 0,
  partition = "no",
  encoding = NULL,
  ...
)
}
\arguments{
\item{path_to_table}{string that indicates the path to the input file (don't forget the extension).}

\item{path_to_parquet}{string that indicates the path to the directory where the parquet files will be stored.}

\item{by_chunk}{Boolean. By default FALSE. If TRUE then it means that the conversion will be done by chunk.}

\item{chunk_size}{this argument must be filled in if `by_chunk` is TRUE. Number of lines that defines the size of the chunk.}

\item{skip}{By default 0. This argument must be filled in if `by_chunk` is TRUE. Number of lines to ignore when converting.}

\item{partition}{string ("yes" or "no" - by default) that indicates whether you want to create a partitioned parquet file.
If "yes", `"partitioning"` argument must be filled in. In this case, a folder will be created for each modality of the variable filled in `"partitioning"`.
Be careful, if `by_chunk` argument is not NULL then a single parquet file will be created.}

\item{encoding}{string that indicates the character encoding for the input file.}

\item{...}{additional format-specific arguments,  see \href{https://arrow.apache.org/docs/r/reference/write_parquet.html}{arrow::write_parquet()}
and \href{https://arrow.apache.org/docs/r/reference/write_dataset.html}{arrow::write_dataset()} for more informations.}
}
\value{
Parquet files, invisibly
}
\description{
This function allows to convert an input file to parquet format. \cr

It handles SAS, SPSS and Stata files in a same function. There is only one function to use for these 3 cases.
For these 3 cases, the function guesses the data format using the extension of the input file (in the `path_to_table` argument). \cr

Two conversions possibilities are offered :

\itemize{

\item{Convert to a single parquet file. Argument `path_to_parquet` must then be used;}
\item{Convert to a partitioned parquet file. Additionnal arguments `partition` and `partitioning` must then be used;}

}

To avoid overcharging R's RAM, the conversion can be done by chunk. Argument `by_chunk` must then be used.
This is very useful for huge tables and for computers with little RAM because the conversion is then done
with less memory consumption. For more information, see [here](https://ddotta.github.io/parquetize/articles/aa-conversions.html).
}
\examples{
# Conversion from a SAS file to a single parquet file :

table_to_parquet(
  path_to_table = system.file("examples","iris.sas7bdat", package = "haven"),
  path_to_parquet = tempdir()
)

# Conversion from a SPSS file to a single parquet file :

table_to_parquet(
  path_to_table = system.file("examples","iris.sav", package = "haven"),
  path_to_parquet = tempdir(),
)
# Conversion from a Stata file to a single parquet file without progress bar :

table_to_parquet(
  path_to_table = system.file("examples","iris.dta", package = "haven"),
  path_to_parquet = tempdir()
)

# Reading SAS file by chunk and with encoding and conversion
# from a SAS file to a single parquet file :

table_to_parquet(
  path_to_table = system.file("examples","iris.sas7bdat", package = "haven"),
  path_to_parquet = tempdir(),
  by_chunk = TRUE,
  chunk_size = 50,
  encoding = "utf-8"
)

# Conversion from a SAS file to a partitioned parquet file  :

table_to_parquet(
  path_to_table = system.file("examples","iris.sas7bdat", package = "haven"),
  path_to_parquet = tempdir(),
  partition = "yes",
  partitioning =  c("Species") # vector use as partition key
)
}
