\name{FOD}
\alias{FOD}
\alias{FOD.wprof}
\alias{FFOD}
\alias{FFOD.wprof}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Fuzzy First Order Domninance analysis on partial orders
}
\description{
The function \code{FOD} performs the Fuzzy First Order Dominance analysis described in Fattore and Arcagni (forthcoming).
}
\usage{
FFOD(profiles, ...)
\method{FFOD}{wprof}(profiles,
    distributions = as.data.frame(profiles$freq),
    lambda = do.call(
        getlambda, as.list(names(profiles$profiles))
    ),
    alpha = NULL, ...
)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{profiles}{
	an object of class \code{wprof}.
}
  \item{distributions}{
	a \code{data.frame} of frequencies/weights where the columns correspond to the different distributions and the rows to the profiles. The profiles in the rows have to be ordered as in \code{profiles}.
}
  \item{lambda}{
	object of class \code{incidence} representing the partial order of the relative importance of the indicators. By default, the lambda poset is an antichain ( i.e. all the indicators are considered equi-important).
}
  \item{alpha}{
  vector of values to cut the \code{mintr.delta} matrix to generate the posets in the list \code{covers}. Default is \code{NULL} posets are generated for each different value in matrix \code{mintr.delta}.  See section 'Value' below.
}
  \item{\dots}{
any of above.
}
}
\details{
The function requires the set of profiles, through the object \code{profiles} of class \code{wprof}, and the corresponding frequencies, which can be defined by the argument \code{distributions} of class \code{data.frame}.

Notice that a warning is provided if the \code{rownames} of the distributions do not match the \code{rownamens} of the profiles.

Through poset \code{lambda}, it is possible to provide (ordinal) information on the relative importance of the indicators in the multi-indicator system.
}
\value{
An object of class \code{FODposet} containing:
\item{delta}{matrix of the overall dominance degrees.}
\item{mintr.delta}{matrix of the min-transitive closure of matrix \code{delta}.}
\item{global.approx}{L1 distance between \code{delta} and \code{mintr.delta}, divided by the L1 norm of \code{delta}.}
\item{global.approx.corr}{L1 distance between \code{delta} and \code{mintr.delta}, divided by the L1 norm of \code{delta} after removing its diagonal.}
\item{cell.approx}{matrix of absolute differences between the elements of \code{delta} and the elements of \code{mintr.delta}.}
\item{posets.ind}{\code{data.frame} with indicators describing the partial orders obtained as alpha-cuts of the min-transitive closure \code{mintr.delta}. For each poset, the data frame provides: its \code{cardinality}, the number of \code{comparabilities}, the number of \code{incomparabilities} and their ratio (\code{ci.ratio}).}
\item{eqv.classes}{list of boolean matrices specifying, for each alpha-cut, the equivalence classes of the input distributions. Equivalence classes are reported by rows and the initial distributions by columns. If element ij of the matrix is \code{TRUE}, then distribution j  belongs to the i-th equivalence class.}
\item{covers}{list of objects of class \code{cover} comprising the cover matrices of the poset generated by each alpha-cut of \code{mintr.delta}.}
}
\references{
Fattore M., Arcagni A. (forthcoming), F-FOD: Fuzzy First Order Dominance analysis and populations ranking over ordinal multi-indicator systems.
}
\author{
Fattore M., Arcagni A.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
v1 <- as.ordered(c("a", "b", "c", "d"))
v2 <- 1:3
prof <- var2prof(varmod = list(v1 = as.ordered(c("a", "b", "c", "d")), v2 = 1:3))
np <- nrow(prof$profiles)

k <- 10 # number of populations
set.seed(0)
populations <- as.data.frame(lapply(1:k, function(x) round(runif(np)*100)))
rownames(populations) <- rownames(prof$profiles)
names(populations) <- paste0("P", 1:k)

prof
populations

res <- FFOD(profiles = prof, distributions = populations)
res
}
