% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_area_table.R
\name{make_area_table}
\alias{make_area_table}
\title{Make a table of peptide areas}
\usage{
make_area_table(msf_file, min_conf = "High",
  prot_regex = "^>([a-zA-Z0-9._]+)\\\\b", collapse = TRUE)
}
\arguments{
\item{msf_file}{A file path to a Thermo MSF file.}

\item{min_conf}{"High", "Medium", or "Low". The mininum peptide confidence level to retrieve from MSF file.}

\item{prot_regex}{Regular expression where the first group matches a protein name or ID from the protein description. Regex must contain ONE group. The protein description is typically generated from a fasta reference file that was used for the database search.}

\item{collapse}{If TRUE, peptides that match to multiple protein sequences are collapsed into a single row with multiple protein descriptions and protein IDs in the \code{Proteins} and \code{ProteinID} columns separated by semi-colons (";").}
}
\value{
A data frame containing peptide areas for peptides at or above the minimum confidence level.

\item{peptide_id}{a unique peptide ID}
\item{spectrum_id}{a unique spectrum ID}
\item{protein_desc}{protein description from reference database used to assign peptides to protein groups, parsed according to \code{prot_regex}}
\item{sequence}{amino acid sequence (does not show post-translational modifications)}
\item{area}{area under peptide peak}
\item{mass}{peptide mass}
\item{m_z}{mass-to-charge ratio}
\item{charge}{peptide charge}
\item{intensity}{peak intensity; useful if no area is available}
\item{first_scan}{first scan in which peptide appears}
}
\description{
Areas under each peptide peak that can be used downstream for quantitation.
See \code{\link{quantitate}} for protein quantitation.
}
\examples{
make_area_table(parsemsf_example("test_db.msf"))
}

