% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_forest.R
\name{rand_forest}
\alias{rand_forest}
\title{Random forest}
\usage{
rand_forest(
  mode = "unknown",
  engine = "ranger",
  mtry = NULL,
  trees = NULL,
  min_n = NULL
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}

\item{mtry}{An integer for the number of predictors that will
be randomly sampled at each split when creating the tree models.}

\item{trees}{An integer for the number of trees contained in
the ensemble.}

\item{min_n}{An integer for the minimum number of data points
in a node that are required for the node to be split further.}
}
\description{
\code{rand_forest()} defines a model that creates a large number of decision
trees, each independent of the others. The final prediction uses all
predictions from the individual trees and combines them.

There are different ways to fit this model. See the engine-specific pages
for more details:

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("rand_forest")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit.model_spec()}} function is used
with the data.
}
\examples{
show_engines("rand_forest")

rand_forest(mode = "classification", trees = 2000)
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Models with R}}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("rand_forest")}
}
