% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_forest_spark.R
\name{details_rand_forest_spark}
\alias{details_rand_forest_spark}
\title{Random forests via spark}
\description{
\code{\link[sparklyr:ml_random_forest]{sparklyr::ml_random_forest()}} fits a model that creates a large number of
decision trees, each independent of the others. The final prediction uses all
predictions from the individual trees and combines them.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{mtry}: # Randomly Selected Predictors (type: integer, default: see
below)
\item \code{trees}: # Trees (type: integer, default: 20L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 1L)
}

\code{mtry} depends on the number of columns and the model mode. The default
in \code{\link[sparklyr:ml_random_forest]{sparklyr::ml_random_forest()}} is
\code{floor(sqrt(ncol(x)))} for classification and \code{floor(ncol(x)/3)} for
regression.
}

\subsection{Translation from parsnip to the original package (regression)}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{rand_forest(
  mtry = integer(1),
  trees = integer(1),
  min_n = integer(1)
) \%>\%  
  set_engine("spark") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Random Forest Model Specification (regression)
## 
## Main Arguments:
##   mtry = integer(1)
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: spark 
## 
## Model fit template:
## sparklyr::ml_random_forest(x = missing_arg(), formula = missing_arg(), 
##     type = "regression", feature_subset_strategy = integer(1), 
##     num_trees = integer(1), min_instances_per_node = min_rows(~integer(1), 
##         x), seed = sample.int(10^5, 1))
}

\code{min_rows()} and \code{min_cols()} will adjust the number of neighbors if the
chosen value if it is not consistent with the actual data dimensions.
}

\subsection{Translation from parsnip to the original package (classification)}{\if{html}{\out{<div class="sourceCode r">}}\preformatted{rand_forest(
  mtry = integer(1),
  trees = integer(1),
  min_n = integer(1)
) \%>\% 
  set_engine("spark") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Random Forest Model Specification (classification)
## 
## Main Arguments:
##   mtry = integer(1)
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: spark 
## 
## Model fit template:
## sparklyr::ml_random_forest(x = missing_arg(), formula = missing_arg(), 
##     type = "classification", feature_subset_strategy = integer(1), 
##     num_trees = integer(1), min_instances_per_node = min_rows(~integer(1), 
##         x), seed = sample.int(10^5, 1))
}
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Other details}{

For models created using the \code{"spark"} engine, there are several things
to consider.
\itemize{
\item Only the formula interface to via \code{fit()} is available; using
\code{fit_xy()} will generate an error.
\item The predictions will always be in a Spark table format. The names
will be the same as documented but without the dots.
\item There is no equivalent to factor columns in Spark tables so class
predictions are returned as character columns.
\item To retain the model object for a new R session (via \code{save()}), the
\code{model$fit} element of the parsnip object should be serialized via
\code{ml_save(object$fit)} and separately saved to disk. In a new
session, the object can be reloaded and reattached to the parsnip
object.
}
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
