% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c5_rules.R
\name{C5_rules}
\alias{C5_rules}
\title{C5.0 rule-based classification models}
\usage{
C5_rules(mode = "classification", trees = NULL, min_n = NULL, engine = "C5.0")
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "classification".}

\item{trees}{A non-negative integer (no greater than 100) for the number
of members of the ensemble.}

\item{min_n}{An integer greater between zero and nine for the minimum number
of data points in a node that are required for the node to be split further.}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\description{
\code{C5_rules()} defines a model that derives feature rules from a tree for
prediction. A single tree or boosted ensemble can be used. This function can
fit classification models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("C5_rules")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
C5.0 is a classification model that is an extension of the C4.5
model of Quinlan (1993). It has tree- and rule-based versions that also
include boosting capabilities. \code{C5_rules()} enables the version of the model
that uses a series of rules (see the examples below). To make a set of
rules, an initial C5.0 tree is created and flattened into rules. The rules
are pruned, simplified, and ordered. Rule sets are created within each
iteration of boosting.

This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.
}
\examples{
show_engines("C5_rules")

C5_rules()
}
\references{
Quinlan R (1993). \emph{C4.5: Programs for Machine Learning}. Morgan
Kaufmann Publishers.

\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\code{\link[C50:C5.0]{C50::C5.0()}}, \code{\link[C50:C5.0Control]{C50::C5.0Control()}},
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("C5_rules")}
}
