% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubist_rules_Cubist.R
\name{details_cubist_rules_Cubist}
\alias{details_cubist_rules_Cubist}
\title{Cubist rule-based regression models}
\description{
\code{\link[Cubist:cubist.default]{Cubist::cubist()}} fits a model that derives simple feature rules from a tree
ensemble and uses creates regression models within each rule.
\code{\link[rules:rules-internal]{rules::cubist_fit()}} is a wrapper around this function.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{committees}: # Committees (type: integer, default: 1L)
\item \code{neighbors}: # Nearest Neighbors (type: integer, default: 0L)
\item \code{max_rules}: Max. Rules (type: integer, default: NA_integer)
}
}

\subsection{Translation from parsnip to the underlying model call (regression)}{

The \strong{rules} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(rules)

cubist_rules(
  committees = integer(1),
  neighbors = integer(1),
  max_rules = integer(1)
) \%>\%
  set_engine("Cubist") \%>\%
  set_mode("regression") \%>\%
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Cubist Model Specification (regression)
## 
## Main Arguments:
##   committees = integer(1)
##   neighbors = integer(1)
##   max_rules = integer(1)
## 
## Computational engine: Cubist 
## 
## Model fit template:
## rules::cubist_fit(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     committees = integer(1), neighbors = integer(1), max_rules = integer(1))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{References}{
\itemize{
\item Quinlan R (1992). “Learning with Continuous Classes.” Proceedings of
the 5th Australian Joint Conference On Artificial Intelligence,
pp. 343-348.
\item Quinlan R (1993).”Combining Instance-Based and Model-Based
Learning.” Proceedings of the Tenth International Conference on
Machine Learning, pp. 236-243.
\item Kuhn M and Johnson K (2013). \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
