% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_ml.R
\name{auto_ml}
\alias{auto_ml}
\title{Automatic Machine Learning}
\usage{
auto_ml(mode = "unknown", engine = "h2o")
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\description{
\code{auto_ml()} defines an automated searching and tuning process where
many models of different families are trained and ranked given their
performance on the training data.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("auto_ml")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("auto_ml")}
}
