% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_neighbor.R
\name{nearest_neighbor}
\alias{nearest_neighbor}
\title{K-nearest neighbors}
\usage{
nearest_neighbor(
  mode = "unknown",
  engine = "kknn",
  neighbors = NULL,
  weight_func = NULL,
  dist_power = NULL
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}

\item{neighbors}{A single integer for the number of neighbors
to consider (often called \code{k}). For \pkg{kknn}, a value of 5
is used if \code{neighbors} is not specified.}

\item{weight_func}{A \emph{single} character for the type of kernel function used
to weight distances between samples. Valid choices are: \code{"rectangular"},
\code{"triangular"}, \code{"epanechnikov"}, \code{"biweight"}, \code{"triweight"},
\code{"cos"}, \code{"inv"}, \code{"gaussian"}, \code{"rank"}, or \code{"optimal"}.}

\item{dist_power}{A single number for the parameter used in
calculating Minkowski distance.}
}
\description{
\code{nearest_neighbor()} defines a model that uses the \code{K} most similar data
points from the training set to predict new samples. This function can
fit classification and regression models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("nearest_neighbor")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.

Each of the arguments in this function other than \code{mode} and \code{engine} are
captured as \link[rlang:topic-quosure]{quosures}. To pass values
programmatically, use the \link[rlang:injection-operator]{injection operator} like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{value <- 1
nearest_neighbor(argument = !!value)
}\if{html}{\out{</div>}}
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
show_engines("nearest_neighbor")

nearest_neighbor(neighbors = 11)
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("nearest_neighbor")}
}
