\name{cforest}
\alias{cforest}
\alias{varimp}
\alias{proximity}
\title{ Random Forest }
\description{
    An implementation of the random forest and bagging ensemble algorithms
    utilizing conditional inference trees as base learners.
}
\usage{
cforest(formula, data = list(), subset = NULL, weights = NULL, 
        controls = cforest_unbiased(),
        xtrafo = ptrafo, ytrafo = ptrafo, scores = NULL)
varimp(object, mincriterion = 0.0)
proximity(object)
}
\arguments{
  \item{formula}{ a symbolic description of the model to be fit. }
  \item{data}{ an data frame containing the variables in the model. }
  \item{subset}{ an optional vector specifying a subset of observations to be
                 used in the fitting process.}
  \item{weights}{ an optional vector of weights to be used in the fitting
                  process. Non-negative integer valued weights are
                  allowed as well as non-negative real weights.
                  Observations are sampled (with or without replacement)
                  according to probabilities \code{weights / sum(weights)}.
                  The fraction of observations to be sampled (without replacement)
                  is computed based on the sum of the weights if all weights
                  are integer-valued and based on the number of weights greater zero
                  else. }
  \item{controls}{an object of class \code{\link{ForestControl-class}}, which can be
                  obtained using \code{\link{cforest_control}} (and its
		  convenience interface \code{cforest_classical} and
		  \code{cforest_unbiased}).}
  \item{xtrafo}{ a function to be applied to all input variables.
                By default, the \code{\link{ptrafo}} function is applied.}
  \item{ytrafo}{ a function to be applied to all response variables.
                By default, the \code{\link{ptrafo}} function is applied.}
  \item{scores}{ an optional named list of scores to be attached to ordered
               factors.}
  \item{object}{ an object as returned by \code{cforest}.}
  \item{mincriterion}{ the value of the test statistic or 1 - p-value that
                       must be exceeded in order make use of a split. 
                       See \code{\link{ctree_control}}.}
}
\details{

  This implementation of the random forest (and bagging) algorithm differs
  from the reference implementation in \code{\link[randomForest]{randomForest}}
  with respect to the base learner used and the aggregation scheme applied.
  
  Conditional inference trees, see \code{\link{ctree}}, are fitted to each
  of the \code{ntree} (defined via \code{\link{cforest_control}}) 
  bootstrap samples of the learning sample. There are many
  hyper parameters that can be controlled, see \code{\link{cforest_control}}.
  You MUST NOT change anything you don't understand completely.

  The aggregation scheme works by averaging observation weights extracted
  from each of the \code{ntree} trees and NOT by averaging predictions directly.
  See Hothorn et al. (2004) for a description. 
  Predictions can be computed using \code{\link{predict}}. For observations
  with zero weights, predictions are computed from the fitted tree 
  when \code{newdata = NULL}. 

  Ensembles of conditional inference trees have not yet been extensively
  tested, so this routine is meant for the expert user only and its current
  state is rather experimental. However, there are some things that can't be
  done with \code{\link[randomForest]{randomForest}}, for example fitting
  forests to censored response variables or to multivariate and 
  ordered responses.

  By default, unbiased trees (see Strobl et al., 2007) are used
  and five inputs are randomly examined for possible splits in each node
  (\code{mtry} is a hyper parameter and needs to be defined by the user). 
  The defaults can be changed by specifying hyper parameters via the
  \code{\link{cforest_control}} function to the \code{control} argument
  of \code{cforest}.
  Function \code{varimp} can be used to compute variable importance measures
  similar to those computed by \code{\link[randomForest]{importance}}.

  The \code{proximity} matrix is an \eqn{n \times n} matrix \eqn{P} with \eqn{P_{ij}}
  equal to the number of trees where observations \eqn{i} and \eqn{j} 
  are element of the same terminal node.

}
\value{
  An object of class \code{\link{RandomForest-class}}.
}
\references{ 

    Leo Breiman (2001). Random Forests. \emph{Machine Learning}, 45(1), 5--32.

    Torsten Hothorn, Berthold Lausen, Axel Benner and Martin Radespiel-Troeger
    (2004). Bagging Survival Trees. \emph{Statistics in Medicine}, \bold{23}(1), 77--91.

    Torsten Hothorn, Peter Buhlmann, Sandrine Dudoit, Annette Molinaro 
    and Mark J. van der Laan (2006). Survival Ensembles. \emph{Biostatistics}, 
    \bold{7}(3), 355--373.

    Carolin Strobl, Anne-Laure Boulesteix, Achim Zeileis and Torsten Hothorn (2007).
    Bias in Random Forest Variable Importance Measures: Illustrations, Sources and 
    a Solution. \emph{BMC Bioinformatics}, \bold{8}, 25. 
    \url{http://www.biomedcentral.com/1471-2105/8/25/abstract}
}
\examples{

    ### honest (i.e., out-of-bag) cross-classification of
    ### true vs. predicted classes
    table(mammoexp$ME, predict(cforest(ME ~ ., data = mammoexp, 
                               control = cforest_classical(ntree = 50)),
                               OOB = TRUE))

    ### fit forest to censored response
    if (require("ipred")) {

        data("GBSG2", package = "ipred")
        bst <- cforest(Surv(time, cens) ~ ., data = GBSG2, 
                   control = cforest_classical(ntree = 50))

        ### estimate conditional Kaplan-Meier curves
        treeresponse(bst, newdata = GBSG2[1:2,], OOB = TRUE)

        ### if you can't resist to look at individual trees ...
        party:::prettytree(bst@ensemble[[1]], names(bst@data@get("input")))
    }
}
\keyword{tree}
