% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_docs.R
\name{WorldClim_2.1}
\alias{WorldClim_2.1}
\title{Documentation for the WorldClim datasets}
\description{
WorldClim version 2.1 is a database of high spatial resolution global weather and
climate data, covering both the present and future projections.
}
\details{
IMPORTANT: If you use this
dataset, make sure to cite the original publication:

Fick, S.E. and R.J. Hijmans, 2017. WorldClim 2: new 1km spatial resolution
climate surfaces for global land areas. International Journal of Climatology 37 (12): 4302-4315.
\doi{10.1002/joc.5086}

\strong{Present-day reconstructions} are based on the mean for the period 1970-2000,
and are available at multiple resolutions of
10 arc-minutes, 5 arc-minutes, 2.5 arc-minute and 0.5 arc-minutes. The resolution
of interest can be obtained by changing the ending of the dataset name
\emph{WorldClim_2.1_RESm}, e.g. \emph{WorldClim_2.1_10m} or \emph{WorldClim_2.1_5m}
(currently, only 10m and 5m are currently available in \code{pastclim}). In \code{pastclim}, the datasets are given
a date of 1985 CE (the mid-point of the period of interest). There are 19 “bioclimatic” variables, as well as monthly
estimates for minimum, mean, and maximum temperature, and precipitation.

\strong{Future projections} are based on the models in CMIP6, downscaled and de-biased
using WorldClim 2.1 for the present as a baseline. Monthly values of minimum
temperature, maximum temperature, and precipitation, as well as 19 bioclimatic
variables were processed for
23 global climate models (GCMs), and for four
Shared Socio-economic Pathways (SSPs): 126, 245, 370 and 585. Model and
SSP can be chosen by changing the ending of the dataset name
\emph{WorldClim_2.1_GCM_SSP_RESm}.

Available values for GCM are: "ACCESS-CM2",
"BCC-CSM2-MR", "CMCC-ESM2", "EC-Earth3-Veg", "FIO-ESM-2-0",
"GFDL-ESM4", "GISS-E2-1-G", "HadGEM3-GC31-LL", "INM-CM5-0", "IPSL-CM6A-LR",
"MIROC6", "MPI-ESM1-2-HR", "MRI-ESM2-0", and "UKESM1-0-LL". For SSP, use: "ssp126",
"ssp245",	"ssp370",	and "ssp585". RES takes the same values as for present reconstructions
(i.e. "10m", "5m", "2.5m", and "0.5m"). Example dataset names are
\emph{WorldClim_2.1_ACCESS-CM2_ssp245_10m} and \emph{WorldClim_2.1_MRI-ESM2-0_ssp370_5m}.
Four combination (namely \emph{FIO-ESM-2-0_ssp370}, \emph{GFDL-ESM4_ssp245},
\emph{GFDL-ESM4_ssp585}, and \emph{HadGEM3-GC31-LL_ssp370}) are NOT available.

The dataset are averages over 20 year
periods (2021-2040, 2041-2060, 2061-2080, 2081-2100).
In \code{pastclim}, the midpoints of the periods (2030, 2050, 2070, 2090) are used as the time stamps. All 4 periods
are automatically downloaded for each combination of GCM model and SSP, and are selected
as usual by defining the time in functions such as \code{\link[=region_slice]{region_slice()}}.
}
