% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathmap.R
\name{pathmap}
\alias{pathmap}
\title{Annotate Involved Genes In Pathways and Visualize Pathways}
\usage{
pathmap(pw_table, gene_data)
}
\arguments{
\item{pw_table}{Data frame of enrichment results. Must-have columns are: "ID" and
"Pathway".}

\item{gene_data}{Single column data frame containing change values (e.g.
log(fold change) values) for significant genes. Row names are gene symbols.}
}
\value{
The function returns the input data frame with genes involved in each pathway.
  Added columns are: "Up_regulated" and "Down_regulated", the up- and down-regulated genes,
  respectively. The function also creates visualizations of the pathways with
  the package \code{pathview} and saves them in the folder "pathway_maps"
  under the current working directory.
}
\description{
Annotate Involved Genes In Pathways and Visualize Pathways
}
\examples{
\dontrun{
pathmap(pathway_table, change_data)
}
}
\seealso{
\code{\link[pathview]{pathview}} for pathway-based data integration
  and visualization. See \code{\link{run_pathfindR}} for the wrapper function
  of the pathfindR workflow
}
