% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{relabel_viewr_axes}
\alias{relabel_viewr_axes}
\title{Relabel the dimensions as length, width, and height}
\usage{
relabel_viewr_axes(
  obj_name,
  tunnel_length = "_z",
  tunnel_width = "_x",
  tunnel_height = "_y",
  real = "_w",
  ...
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{tunnel_length}{The dimension that corresponds to tunnel length. Set to
\code{tunnel_length = "_z"} by default. Argument should contain a character
vector with a leading underscore (see Details)}

\item{tunnel_width}{The dimension that corresponds to tunnel width. Follows
the same conventions as \code{tunnel_length} and defaults to
\code{tunnel_length = "_x"}}

\item{tunnel_height}{The dimension that corresponds to tunnel height. Follows
the same conventions as \code{tunnel_length} and defaults to
\code{tunnel_length = "_y"}}

\item{real}{The dimension that corresponds to the "real" parameter in
quaternion notation (for data with "rotation" values). Follows the same
conventions as \code{tunnel_length} and defaults to \code{real = "_w"}}

\item{...}{Additional arguments to be passed to \code{read_motive_csv()}.}
}
\value{
A tibble or data.frame with variables that have been renamed.
}
\description{
Axes are commonly labeled as "x", "y", and "z" in recording software yet
\code{pathviewr} functions require these to be labeled as "length", "width",
and "height". \code{relabel_viewr_axes()} is a function that takes a
\code{viewr} object and allows the user to rename its variables.
}
\details{
Each argument must have a leading underscore ("_") and each
argument must have an entry. E.g. tunnel_length = "_Y" will replace all
instances of _Y with _length in the names of variables.
}
\examples{

library(pathviewr)

## Import the Motive example data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                             package = 'pathviewr'))

## Names of variables are labeled with _x, _y, _z, which we'd like to rename
names(motive_data)

## Now use relabel_viewr_axes() to rename these variables using _length,
## _width, and _height instead
motive_data_relabeled <-
  relabel_viewr_axes(motive_data,
                     tunnel_length = "_z",
                     tunnel_width = "_x",
                     tunnel_height = "_y",
                     real = "_w")

## See the result
names(motive_data_relabeled)
}
\seealso{
Other data cleaning functions: 
\code{\link{gather_tunnel_data}()},
\code{\link{get_full_trajectories}()},
\code{\link{quick_separate_trajectories}()},
\code{\link{redefine_tunnel_center}()},
\code{\link{rename_viewr_characters}()},
\code{\link{rotate_tunnel}()},
\code{\link{select_x_percent}()},
\code{\link{separate_trajectories}()},
\code{\link{standardize_tunnel}()},
\code{\link{trim_tunnel_outliers}()},
\code{\link{visualize_frame_gap_choice}()}
}
\author{
Vikram B. Baliga
}
\concept{data cleaning functions}
