% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{GenePathwayOncoplots}
\alias{GenePathwayOncoplots}
\title{draw an GenePathwayOncoplots}
\usage{
GenePathwayOncoplots(
  maffile,
  gene_path,
  freq_matrix,
  risk_score,
  cut_off,
  final_character,
  isTCGA = FALSE,
  top = 20,
  clinicalFeatures = "sample_group",
  annotationColor = c("red", "green"),
  sortByAnnotation = TRUE,
  removeNonMutated = FALSE,
  drawRowBar = TRUE,
  drawColBar = TRUE,
  leftBarData = NULL,
  leftBarLims = NULL,
  rightBarData = NULL,
  rightBarLims = NULL,
  topBarData = NULL,
  logColBar = FALSE,
  draw_titv = FALSE,
  showTumorSampleBarcodes = FALSE,
  fill = TRUE,
  showTitle = TRUE,
  titleText = NULL
)
}
\arguments{
\item{maffile}{an MAF object generated by read.maf.}

\item{gene_path}{User input pathways geneset list.}

\item{freq_matrix}{The mutations matrix,generated by `get_mut_matrix`.}

\item{risk_score}{Samples' PTMB-related risk score,which could be a biomarker for survival analysis and immunotherapy prediction.}

\item{cut_off}{A threshold value(the median risk score as the default value).Using this value to divide the sample into high and low risk groups with different overall survival.}

\item{final_character}{The pathway signature,use to map gene in the GenePathwayOncoplots.}

\item{isTCGA}{Is input MAF file from TCGA source. If TRUE uses only first 12 characters from Tumor_Sample_Barcode.}

\item{top}{how many top genes to be drawn,genes are arranged from high to low depending on the frequency of mutations. defaults to 20.}

\item{clinicalFeatures}{columns names from 'clinical.data' slot of MAF to be drawn in the plot. Dafault "sample_group".}

\item{annotationColor}{Custom colors to use for sample annotation-"sample_group". Must be a named list containing a named vector of colors. Default "red" and "green".}

\item{sortByAnnotation}{logical sort oncomatrix (samples) by provided 'clinicalFeatures'. Sorts based on first 'clinicalFeatures'. Defaults to TRUE. column-sort.}

\item{removeNonMutated}{Logical. If TRUE removes samples with no mutations in the GenePathwayOncoplots for better visualization. Default FALSE.}

\item{drawRowBar}{logical. Plots righ barplot for each gene. Default TRUE.}

\item{drawColBar}{logical plots top barplot for each sample. Default TRUE.}

\item{leftBarData}{Data for leftside barplot. Must be a data.frame with two columns containing gene names and values. Default 'NULL'.}

\item{leftBarLims}{limits for 'leftBarData'. Default 'NULL'.}

\item{rightBarData}{Data for rightside barplot. Must be a data.frame with two columns containing to gene names and values. Default 'NULL' which draws distibution by variant classification. This option is applicable when only 'drawRowBar' is TRUE.}

\item{rightBarLims}{limits for 'rightBarData'. Default 'NULL'.}

\item{topBarData}{Default 'NULL' which draws absolute number of mutation load for each sample. Can be overridden by choosing one clinical indicator(Numeric) or by providing a two column data.frame contaning sample names and values for each sample. This option is applicable when only 'drawColBar' is TRUE.}

\item{logColBar}{Plot top bar plot on log10 scale. Default FALSE.}

\item{draw_titv}{logical Includes TiTv plot. Default FALSE}

\item{showTumorSampleBarcodes}{logical to include sample names.}

\item{fill}{Logical. If TRUE draws genes and samples as blank grids even when they are not altered.}

\item{showTitle}{Default TRUE.}

\item{titleText}{Custom title. Default 'NULL'.}
}
\value{
No return value
}
\description{
takes output generated by read.maf and draws an GenePathwayOncoplots.
}
\examples{
#get the path of the mutation annotation file and samples' survival data
maf<-system.file("extdata","data_mutations_extended.txt",package = "pathwayTMB")
sur_path<-system.file("extdata","sur.csv",package = "pathwayTMB")
sur<-read.csv(sur_path,header=TRUE,row.names = 1)
#perform the function 'get_mut_matrix'
mut_matrix<-get_mut_matrix(maffile=maf,mut_fre = 0.01,is.TCGA=FALSE,sur=sur)
#perform the function `get_PTMB`
PTMB_matrix<-get_PTMB(freq_matrix=mut_matrix,genesmbol=genesmbol,gene_path=gene_path)
\donttest{set.seed(1)
final_character<-get_final_signature(PTMB=PTMB_matrix,sur=sur)}
#calculate the risksciore
riskscore<-plotKMcurves(t(PTMB_matrix[final_character,]),sur=sur,plots=FALSE)$risk_score
cut<-median(riskscore)
\donttest{GenePathwayOncoplots(maf,gene_path,mut_matrix,riskscore,cut,final_character)}

}
