% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subjectProfileTextPlot.R
\name{subjectProfileTextPlot}
\alias{subjectProfileTextPlot}
\title{Visualize text-information in subject profiles.}
\usage{
subjectProfileTextPlot(
  data,
  paramValueVar,
  paramValueLab = getLabelVar(paramValueVar, labelVars = labelVars),
  paramNameVar = NULL,
  paramGroupVar = NULL,
  subsetData = NULL,
  subsetVar = NULL,
  subsetValue = NULL,
  subjectVar = "USUBJID",
  subjectSubset = NULL,
  subjectSample = NULL,
  seed = 123,
  xLab = "",
  yLab = "",
  title = "Subject information",
  label = title,
  labelVars = NULL,
  paramVarSep = " - ",
  formatReport = subjectProfileReportFormat(),
  paging = TRUE,
  table = FALSE,
  colWidth = NULL
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{paramValueVar}{Character vector, either:
\itemize{
\item{vector with names of variable(s) (multiple are possible) 
of \code{data} of interest.
The values are displayed in the plot area and variable name in the labels
of the y-axis.\cr
Multiple variables can be concatenated in the same line by specifying them,
as an unique string separated by a 'pipe', e.g 'SEX|AGE'. Variable
label(s) are concatenated (with ', ') and displayed in the y-axis.}
\item{if \code{paramNameVar} is specified: }{
\itemize{
\item{character vector with names of variable(s) (multiple possible) 
of \code{data} with values to represent in the plot area.
}
\item{function taking \code{data} as input and 
returning a new variable (of length equal to number of rows in \code{data}) 
with parameter value to represent}
}}
}}

\item{paramValueLab}{(optional) Named character vector with
labels for \code{paramValueVar}.}

\item{paramNameVar}{(optional) Character vector of length 1 with
variable of \code{data} with parameter name. This
is displayed in the labels of the y-axis.}

\item{paramGroupVar}{(optional) Character vector with variable(s) 
of \code{data} based on which the data will be grouped and sorted 
(in the y-axis) in the plot.}

\item{subsetData}{(optional) Data.frame with extra dataset to filter on.
This dataset is filtered, and only records from \code{data} 
with common subject IDs will be retained.\cr
If not specified, \code{data} is used.}

\item{subsetVar}{(optional) String with variable of subset data to filter on.
\code{subsetValue} should be specified too.\cr
If not specified, all records from the subset data are retained.}

\item{subsetValue}{(optional) Character vector with value(s) of interest to
retain in the filtered data.
These values should be available in \code{subsetVar}.\cr
Missing values in the subject variable are not retained 
in the filtered data.}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{subjectSubset}{(optional) Character vector with subjects of interest 
(available in \code{subjectVar}), NULL by default.}

\item{subjectSample}{(optional) Integer of length 1
with number of random subject(s) that should be considered,
e.g. to check the created patient profiles for a subset of the data.
By default, all specified subjects are considered (set to NULL).}

\item{seed}{(optional) Integer of length 1 with seed used to select random subjects 
if \code{subjectSample} is specified (123 by default).}

\item{xLab}{String, label for the x-axis.}

\item{yLab}{String, label for the y-axis.}

\item{title}{String with title, 'Subject information' by default.}

\item{label}{String, label for the visualization.
This label is stored as attributes of the output
from the \code{subjectProfile[]Plot} function.\cr
This label is displayed in the final profile
report, in case no data is available for
for a specific patient, as: 'No [label] available.'}

\item{labelVars}{Named character vector with variable labels 
(names are the variable code)}

\item{paramVarSep}{String (' - ' by default) 
with character(s) used to concatenate multiple 
variables for the same record in the plot area.}

\item{formatReport}{list with parameters used to specify the format of the report,
e.g. output of the \code{\link{subjectProfileReportFormat}} function}

\item{paging}{Logical, if TRUE (by default), automatic 
paging is enabled, so patient profiles module too big to fit
in one page will span multiple pages.
Please note that the size of the graphic window 
(or report page) may need
to be re-sized in order that the plot fits.
\cr
If FALSE, the entire plot is included in one single page.}

\item{table}{Logical, if TRUE (FALSE by default) the information
contained in the variables: \code{paramValueVar} is displayed as a table. 
Otherwise, the values of the different variables are concatenated in the same line.}

\item{colWidth}{Numeric vector with approximate
width of each parameter value column
for a table layout.\cr
For example in case two parameters are specified: 
\code{c(0.8, 0.2))} such as the first column
takes 80\% of plot area, and the second column 20\%.\cr
Note: columns can be slightly bigger if their content is 
larger than the specified width.
If not specified, column width is optimized
based on the max length of the character in each column.}
}
\value{
list of (across subjects) of list (across modules) of \code{\link[ggplot2]{ggplot2} objects}, 
also of class \code{subjectProfileTextPlot}, with additional \code{metaData} 
attributes containing
'\code{label}' and 'timeLim'.
}
\description{
There are two ways to specify the variables of interest to include:
\itemize{
\item{by specifying column(s) of interest containing parameter values, passed
to the \code{paramValueVar} parameter.\cr
In this case, variable value is displayed in the plot area,
and variable name in the label of the y-axis, as:\cr
variable 1 | value 1 - value 2 - ...\cr
variable 2 | value 1 - value 2 - ...
}
\item{by specifying column(s) of interest containing parameter values,
displayed as a \code{table}. \cr
In this case, variable are displayed in columns
in the plot area. Variable names are displayed 
on top of table, and associated values below, as:\cr
| variable 1      variable 2\cr
| value 1         value 1
| ...
}
\item{by specifying a combination of a variable containing the parameter name
(\code{paramNameVar}), coupled with a variable containing the 
parameter values (\code{paramValueVar}).\cr
In this case, parameter values (if multiple) are concatenated 
and displayed in the plot area for each parameter name,
displayed in the label of the y-axis, as:\cr
variable name 1 | variable value 1 - variable value 2 - ...\cr
variable name 2 | variable value 1 - ...
}
}
}
\seealso{
Other patient profiles plotting function: 
\code{\link{subjectProfileEventPlot}()},
\code{\link{subjectProfileIntervalPlot}()},
\code{\link{subjectProfileLinePlot}()}
}
\author{
Laure Cougnaud
}
\concept{patient profiles plotting function}
