% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_defineIndex.R
\name{defineIndex}
\alias{defineIndex}
\title{Define LaTeX index based on specified variable(s)
of the dataset}
\usage{
defineIndex(subjects, data, var, subjectVar = "USUBJID", labelVars = NULL)
}
\arguments{
\item{subjects}{vector with subject IDs (based on the \code{subjectVar} variable)}

\item{data}{data.frame with data containing information on which the index should be based}

\item{var}{variable(s) of \code{data} of interest for the index}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{labelVars}{Named character vector with variable labels 
(names are the variable code)}
}
\value{
list with elements:
\itemize{
\item{'indexDef': string with LaTeX code for creation of index, 
to be included directly with \code{\link{cat}} in a knitr document
(two backslashes)
}
\item{'indexInfo': character vector, named with named with subject ID,
 containing LaTeX code for index for each subject
specified in \code{subjects} parameter, to be passed to the 
\code{\link{knit}} function as text (four backslashes)}
\item{'indexPrint': string with LaTeX code for printing/inclusion of index, 
to be included directly with \code{\link{cat}} in a knitr document
(two backslashes)}
}
}
\description{
Define LaTeX index based on specified variable(s)
of the dataset
}
\author{
Laure Cougnaud
}
