% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/natureOfCausality.R
\name{natureOfCausality}
\alias{natureOfCausality}
\title{Evaluate the Nature of Causality in Dynamic Complex Systems}
\usage{
natureOfCausality(PC, dur, hashedpatterns, X)
}
\arguments{
\item{PC}{A three-dimensional array where each slice along the third dimension represents a pattern causality matrix at a specific time point, encoding the strength and type of causality between pairs of variables.}

\item{dur}{A numeric vector indicating the time points (slices of the PC matrix) to analyze for causality.}

\item{hashedpatterns}{A numeric vector of hashed or indexed pattern identifiers that correspond to variables in the system, used for interpreting matrix dimensions in causality checks.}

\item{X}{An auxiliary numeric vector used to determine the length of the output vectors for causality results, typically aligning with the number of time points or variables.}
}
\value{
A data frame with four columns: 'noCausality', 'Positive', 'Negative', and 'Dark', each containing binary indicators (1 for presence, 0 for absence) that correspond to the presence of each causality type at each time point analyzed.
}
\description{
This function analyzes a three-dimensional pattern causality matrix to classify the nature of causality (positive, negative, dark, or no causality) between pairs of variables across specified time points. It is designed to interpret the dynamics within complex systems by examining the causal relationships encoded in the matrix.
}
\examples{
# Generate a sample 3D causality matrix with random data
set.seed(123) # For reproducibility
PC <- array(runif(300), dim = c(10, 10, 3)) # 10x10 matrix over 3 time points
dur <- 1:3 # Time points to analyze
hashedpatterns <- seq(1, 10) # Simulated hashed pattern identifiers
X <- rep(0, 3) # Auxiliary vector for output length

# Run the natureOfCausality function
results <- natureOfCausality(PC, dur, hashedpatterns, X)
print(results)
}
