% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PC.Mk.II.Lightweight.R
\name{pcLightweight}
\alias{pcLightweight}
\title{Calculate Pattern Causality Using Lightweight Algorithm}
\usage{
pcLightweight(
  X,
  Y,
  E,
  tau,
  h,
  weighted,
  metric = "euclidean",
  distance_fn = NULL,
  state_space_fn = NULL,
  verbose = FALSE
)
}
\arguments{
\item{X}{A numeric vector representing the first time series}

\item{Y}{A numeric vector representing the second time series}

\item{E}{Integer; embedding dimension for state space reconstruction (E > 1)}

\item{tau}{Integer; time delay for state space reconstruction (tau > 0)}

\item{h}{Integer; prediction horizon for future projections (h >= 0)}

\item{weighted}{Logical; whether to use weighted causality strength calculations}

\item{metric}{Character string specifying the distance metric; one of "euclidean",
"manhattan", or "maximum"}

\item{distance_fn}{Custom distance function for state space reconstruction}

\item{state_space_fn}{Custom function for state space transformation}

\item{verbose}{Logical; whether to display progress information (default: FALSE)}
}
\value{
An object of class "pc_fit" containing:
\itemize{
\item total: Total causality strength (0-1)
\item positive: Proportion of positive causality (0-1)
\item negative: Proportion of negative causality (0-1)
\item dark: Proportion of dark causality (0-1)
}
}
\description{
Implements a computationally efficient version of the Pattern Causality
Model Mk. II for analyzing causal interactions between two time series. This function
uses pattern and signature spaces to assess causality through reconstructed state spaces
and hashed pattern analysis.
}
\details{
Calculate Pattern Causality Using Lightweight Algorithm

The function implements these key steps:
\itemize{
\item State space reconstruction using embedding parameters
\item Pattern and signature space transformation
\item Nearest neighbor analysis in reconstructed spaces
\item Causality strength calculation using prediction accuracy
\item Classification of causality types (positive/negative/dark)
}
}
\examples{
data(climate_indices)
X <- climate_indices$AO
Y <- climate_indices$AAO
result <- pcLightweight(X, Y, E = 3, tau = 1, 
                       metric = "euclidean", h = 2, 
                       weighted = TRUE, verbose = FALSE)
print(result)
summary(result)
plot(result)

}
\seealso{
\code{\link{pcFullDetails}} for detailed analysis
\code{\link{pcMatrix}} for analyzing multiple time series
}
