% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.rimg.r
\name{img_conversion}
\alias{img_conversion}
\alias{rimg2cimg}
\alias{cimg2rimg}
\title{Convert images between class rimg and cimg}
\usage{
rimg2cimg(image)

cimg2rimg(image, name = "img")
}
\arguments{
\item{image}{an object of class \code{rimg} or \code{cimg}.}

\item{name}{the name(s) of the image(s).}
}
\value{
an image of the specified class
}
\description{
Conveniently convert single objects of class \code{rimg} and \code{cimg} (from the
package \code{imager}, which contains a suite of useful image-processing
capabilities).
}
\note{
Attributes (e.g. scales, color-classes) will not be preserved following
conversion from class \code{rimg}, so it's best to use early in the analysis workflow.
}
\examples{
\dontrun{
papilio <- getimg(system.file("testdata/images/papilio.png", package = 'pavo'))

# From class rimg to cimg
papilio_cimg <- rimg2cimg(papilio)
class(papilio_cimg)

# From class cimg to rimg
papilio_rimg <- cimg2rimg(papilio_cimg)
class(papilio_rimg)
}

}
\author{
Thomas E. White \email{thomas.white026@gmail.com}

Thomas E. White \email{thomas.white026@gmail.com}

Thomas E. White \email{thomas.white026@gmail.com}
}
