% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.rimg.R
\name{summary.rimg}
\alias{summary.rimg}
\title{Image summary}
\usage{
\method{summary}{rimg}(object, plot = FALSE, axes = TRUE, col = NULL,
  ...)
}
\arguments{
\item{object}{(required) an image of class rimg, or list thereof.}

\item{plot}{logical; plot the image and, if the image is color-classified, the colours
corresponding to colour class categories side-by-side? Defaults to \code{FALSE}.}

\item{axes}{should axes be drawn when \code{plot = TRUE}? (defaults to \code{TRUE}).}

\item{col}{optional vector of colours when plotting colour-classified images with \code{plot = TRUE}.
Defaults to the mean RGB values of the k-means centres (i.e. the 'original' colours).}

\item{...}{additional graphical options when \code{plot = TRUE}. Also see \code{\link{par}}.}
}
\value{
Either the RGB values of the k-means centres from the colour-classified image,
or a plot of both the image and specified colours (when \code{plot = TRUE}.
}
\description{
Returns the attributes of, and optionally plots, an image.
}
\examples{
\dontrun{
papilio <- getimg(system.file("testdata/images/papilio.png", package = "pavo"))
papilio_class <- classify(papilio, kcols = 4)
summary(papilio_class)

# Plot the colour-classified image alongside the colour class palette
summary(papilio_class, plot = TRUE)

# Multiple images
snakes <- getimg(system.file("testdata/images/snakes", package = "pavo"))
snakes_class <- classify(snakes, kcols = 3)
summary(snakes_class, plot = TRUE)
}

}
\author{
Thomas E. White \email{thomas.white026@gmail.com}
}
