# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AWS Glue
#'
#' @description
#' Defines the public endpoint for the AWS Glue service.
#'
#' @examples
#' \donttest{svc <- glue()
#' svc$batch_create_partition(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=glue_batch_create_partition]{batch_create_partition} \tab Creates one or more partitions in a batch operation \cr
#'  \link[=glue_batch_delete_connection]{batch_delete_connection} \tab Deletes a list of connection definitions from the Data Catalog \cr
#'  \link[=glue_batch_delete_partition]{batch_delete_partition} \tab Deletes one or more partitions in a batch operation \cr
#'  \link[=glue_batch_delete_table]{batch_delete_table} \tab Deletes multiple tables at once \cr
#'  \link[=glue_batch_delete_table_version]{batch_delete_table_version} \tab Deletes a specified batch of versions of a table \cr
#'  \link[=glue_batch_get_crawlers]{batch_get_crawlers} \tab Returns a list of resource metadata for a given list of crawler names \cr
#'  \link[=glue_batch_get_dev_endpoints]{batch_get_dev_endpoints} \tab Returns a list of resource metadata for a given list of DevEndpoint names \cr
#'  \link[=glue_batch_get_jobs]{batch_get_jobs} \tab Returns a list of resource metadata for a given list of job names \cr
#'  \link[=glue_batch_get_partition]{batch_get_partition} \tab Retrieves partitions in a batch request \cr
#'  \link[=glue_batch_get_triggers]{batch_get_triggers} \tab Returns a list of resource metadata for a given list of trigger names \cr
#'  \link[=glue_batch_stop_job_run]{batch_stop_job_run} \tab Stops one or more job runs for a specified job definition \cr
#'  \link[=glue_create_classifier]{create_classifier} \tab Creates a classifier in the user's account \cr
#'  \link[=glue_create_connection]{create_connection} \tab Creates a connection definition in the Data Catalog \cr
#'  \link[=glue_create_crawler]{create_crawler} \tab Creates a new crawler with specified targets, role, configuration, and optional schedule \cr
#'  \link[=glue_create_database]{create_database} \tab Creates a new database in a Data Catalog \cr
#'  \link[=glue_create_dev_endpoint]{create_dev_endpoint} \tab Creates a new DevEndpoint \cr
#'  \link[=glue_create_job]{create_job} \tab Creates a new job definition \cr
#'  \link[=glue_create_partition]{create_partition} \tab Creates a new partition \cr
#'  \link[=glue_create_script]{create_script} \tab Transforms a directed acyclic graph (DAG) into code \cr
#'  \link[=glue_create_security_configuration]{create_security_configuration} \tab Creates a new security configuration \cr
#'  \link[=glue_create_table]{create_table} \tab Creates a new table definition in the Data Catalog \cr
#'  \link[=glue_create_trigger]{create_trigger} \tab Creates a new trigger \cr
#'  \link[=glue_create_user_defined_function]{create_user_defined_function} \tab Creates a new function definition in the Data Catalog \cr
#'  \link[=glue_delete_classifier]{delete_classifier} \tab Removes a classifier from the Data Catalog \cr
#'  \link[=glue_delete_connection]{delete_connection} \tab Deletes a connection from the Data Catalog \cr
#'  \link[=glue_delete_crawler]{delete_crawler} \tab Removes a specified crawler from the Data Catalog, unless the crawler state is RUNNING \cr
#'  \link[=glue_delete_database]{delete_database} \tab Removes a specified Database from a Data Catalog \cr
#'  \link[=glue_delete_dev_endpoint]{delete_dev_endpoint} \tab Deletes a specified DevEndpoint \cr
#'  \link[=glue_delete_job]{delete_job} \tab Deletes a specified job definition \cr
#'  \link[=glue_delete_partition]{delete_partition} \tab Deletes a specified partition \cr
#'  \link[=glue_delete_resource_policy]{delete_resource_policy} \tab Deletes a specified policy \cr
#'  \link[=glue_delete_security_configuration]{delete_security_configuration} \tab Deletes a specified security configuration \cr
#'  \link[=glue_delete_table]{delete_table} \tab Removes a table definition from the Data Catalog \cr
#'  \link[=glue_delete_table_version]{delete_table_version} \tab Deletes a specified version of a table \cr
#'  \link[=glue_delete_trigger]{delete_trigger} \tab Deletes a specified trigger \cr
#'  \link[=glue_delete_user_defined_function]{delete_user_defined_function} \tab Deletes an existing function definition from the Data Catalog \cr
#'  \link[=glue_get_catalog_import_status]{get_catalog_import_status} \tab Retrieves the status of a migration operation \cr
#'  \link[=glue_get_classifier]{get_classifier} \tab Retrieve a classifier by name \cr
#'  \link[=glue_get_classifiers]{get_classifiers} \tab Lists all classifier objects in the Data Catalog \cr
#'  \link[=glue_get_connection]{get_connection} \tab Retrieves a connection definition from the Data Catalog \cr
#'  \link[=glue_get_connections]{get_connections} \tab Retrieves a list of connection definitions from the Data Catalog \cr
#'  \link[=glue_get_crawler]{get_crawler} \tab Retrieves metadata for a specified crawler \cr
#'  \link[=glue_get_crawler_metrics]{get_crawler_metrics} \tab Retrieves metrics about specified crawlers \cr
#'  \link[=glue_get_crawlers]{get_crawlers} \tab Retrieves metadata for all crawlers defined in the customer account \cr
#'  \link[=glue_get_data_catalog_encryption_settings]{get_data_catalog_encryption_settings} \tab Retrieves the security configuration for a specified catalog \cr
#'  \link[=glue_get_database]{get_database} \tab Retrieves the definition of a specified database \cr
#'  \link[=glue_get_databases]{get_databases} \tab Retrieves all Databases defined in a given Data Catalog \cr
#'  \link[=glue_get_dataflow_graph]{get_dataflow_graph} \tab Transforms a Python script into a directed acyclic graph (DAG) \cr
#'  \link[=glue_get_dev_endpoint]{get_dev_endpoint} \tab Retrieves information about a specified DevEndpoint \cr
#'  \link[=glue_get_dev_endpoints]{get_dev_endpoints} \tab Retrieves all the DevEndpoints in this AWS account \cr
#'  \link[=glue_get_job]{get_job} \tab Retrieves an existing job definition \cr
#'  \link[=glue_get_job_run]{get_job_run} \tab Retrieves the metadata for a given job run \cr
#'  \link[=glue_get_job_runs]{get_job_runs} \tab Retrieves metadata for all runs of a given job definition \cr
#'  \link[=glue_get_jobs]{get_jobs} \tab Retrieves all current job definitions \cr
#'  \link[=glue_get_mapping]{get_mapping} \tab Creates mappings \cr
#'  \link[=glue_get_partition]{get_partition} \tab Retrieves information about a specified partition \cr
#'  \link[=glue_get_partitions]{get_partitions} \tab Retrieves information about the partitions in a table \cr
#'  \link[=glue_get_plan]{get_plan} \tab Gets code to perform a specified mapping \cr
#'  \link[=glue_get_resource_policy]{get_resource_policy} \tab Retrieves a specified resource policy \cr
#'  \link[=glue_get_security_configuration]{get_security_configuration} \tab Retrieves a specified security configuration \cr
#'  \link[=glue_get_security_configurations]{get_security_configurations} \tab Retrieves a list of all security configurations \cr
#'  \link[=glue_get_table]{get_table} \tab Retrieves the Table definition in a Data Catalog for a specified table \cr
#'  \link[=glue_get_table_version]{get_table_version} \tab Retrieves a specified version of a table \cr
#'  \link[=glue_get_table_versions]{get_table_versions} \tab Retrieves a list of strings that identify available versions of a specified table \cr
#'  \link[=glue_get_tables]{get_tables} \tab Retrieves the definitions of some or all of the tables in a given Database \cr
#'  \link[=glue_get_tags]{get_tags} \tab Retrieves a list of tags associated with a resource \cr
#'  \link[=glue_get_trigger]{get_trigger} \tab Retrieves the definition of a trigger \cr
#'  \link[=glue_get_triggers]{get_triggers} \tab Gets all the triggers associated with a job \cr
#'  \link[=glue_get_user_defined_function]{get_user_defined_function} \tab Retrieves a specified function definition from the Data Catalog \cr
#'  \link[=glue_get_user_defined_functions]{get_user_defined_functions} \tab Retrieves a multiple function definitions from the Data Catalog \cr
#'  \link[=glue_import_catalog_to_glue]{import_catalog_to_glue} \tab Imports an existing Athena Data Catalog to AWS Glue \cr
#'  \link[=glue_list_crawlers]{list_crawlers} \tab Retrieves the names of all crawler resources in this AWS account, or the resources with the specified tag \cr
#'  \link[=glue_list_dev_endpoints]{list_dev_endpoints} \tab Retrieves the names of all DevEndpoint resources in this AWS account, or the resources with the specified tag \cr
#'  \link[=glue_list_jobs]{list_jobs} \tab Retrieves the names of all job resources in this AWS account, or the resources with the specified tag \cr
#'  \link[=glue_list_triggers]{list_triggers} \tab Retrieves the names of all trigger resources in this AWS account, or the resources with the specified tag \cr
#'  \link[=glue_put_data_catalog_encryption_settings]{put_data_catalog_encryption_settings} \tab Sets the security configuration for a specified catalog \cr
#'  \link[=glue_put_resource_policy]{put_resource_policy} \tab Sets the Data Catalog resource policy for access control \cr
#'  \link[=glue_reset_job_bookmark]{reset_job_bookmark} \tab Resets a bookmark entry \cr
#'  \link[=glue_start_crawler]{start_crawler} \tab Starts a crawl using the specified crawler, regardless of what is scheduled \cr
#'  \link[=glue_start_crawler_schedule]{start_crawler_schedule} \tab Changes the schedule state of the specified crawler to SCHEDULED, unless the crawler is already running or the schedule state is already SCHEDULED\cr
#'  \link[=glue_start_job_run]{start_job_run} \tab Starts a job run using a job definition \cr
#'  \link[=glue_start_trigger]{start_trigger} \tab Starts an existing trigger \cr
#'  \link[=glue_stop_crawler]{stop_crawler} \tab If the specified crawler is running, stops the crawl \cr
#'  \link[=glue_stop_crawler_schedule]{stop_crawler_schedule} \tab Sets the schedule state of the specified crawler to NOT_SCHEDULED, but does not stop the crawler if it is already running \cr
#'  \link[=glue_stop_trigger]{stop_trigger} \tab Stops a specified trigger \cr
#'  \link[=glue_tag_resource]{tag_resource} \tab Adds tags to a resource \cr
#'  \link[=glue_untag_resource]{untag_resource} \tab Removes tags from a resource \cr
#'  \link[=glue_update_classifier]{update_classifier} \tab Modifies an existing classifier (a GrokClassifier, an XMLClassifier, a JsonClassifier, or a CsvClassifier, depending on which field is present) \cr
#'  \link[=glue_update_connection]{update_connection} \tab Updates a connection definition in the Data Catalog \cr
#'  \link[=glue_update_crawler]{update_crawler} \tab Updates a crawler \cr
#'  \link[=glue_update_crawler_schedule]{update_crawler_schedule} \tab Updates the schedule of a crawler using a cron expression \cr
#'  \link[=glue_update_database]{update_database} \tab Updates an existing database definition in a Data Catalog \cr
#'  \link[=glue_update_dev_endpoint]{update_dev_endpoint} \tab Updates a specified DevEndpoint \cr
#'  \link[=glue_update_job]{update_job} \tab Updates an existing job definition \cr
#'  \link[=glue_update_partition]{update_partition} \tab Updates a partition \cr
#'  \link[=glue_update_table]{update_table} \tab Updates a metadata table in the Data Catalog \cr
#'  \link[=glue_update_trigger]{update_trigger} \tab Updates a trigger definition \cr
#'  \link[=glue_update_user_defined_function]{update_user_defined_function} \tab Updates an existing function definition in the Data Catalog 
#' }
#'
#' @rdname glue
#' @export
glue <- function() {
  .glue$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.glue <- list()

.glue$operations <- list()

.glue$metadata <- list(
  service_name = "glue",
  endpoints = list("*" = "glue.{region}.amazonaws.com", "cn-*" = "glue.{region}.amazonaws.com.cn"),
  service_id = "Glue",
  api_version = "2017-03-31",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "AWSGlue"
)

.glue$handlers <- new_handlers("jsonrpc", "v4")

.glue$service <- function() {
  new_service(.glue$metadata, .glue$handlers)
}
