# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Amazon Kinesis Analytics
#'
#' 
#'
#' @examples
#' \donttest{svc <- kinesisanalytics()
#' svc$add_application_cloud_watch_logging_option(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=kinesisanalytics_add_application_cloud_watch_logging_option]{add_application_cloud_watch_logging_option} \tab Adds a CloudWatch log stream to monitor application configuration errors \cr
#'  \link[=kinesisanalytics_add_application_input]{add_application_input} \tab Adds a streaming source to your Amazon Kinesis application \cr
#'  \link[=kinesisanalytics_add_application_input_processing_configuration]{add_application_input_processing_configuration} \tab Adds an InputProcessingConfiguration to an application \cr
#'  \link[=kinesisanalytics_add_application_output]{add_application_output} \tab Adds an external destination to your Amazon Kinesis Analytics application \cr
#'  \link[=kinesisanalytics_add_application_reference_data_source]{add_application_reference_data_source} \tab Adds a reference data source to an existing application \cr
#'  \link[=kinesisanalytics_create_application]{create_application} \tab Creates an Amazon Kinesis Analytics application \cr
#'  \link[=kinesisanalytics_delete_application]{delete_application} \tab Deletes the specified application \cr
#'  \link[=kinesisanalytics_delete_application_cloud_watch_logging_option]{delete_application_cloud_watch_logging_option} \tab Deletes a CloudWatch log stream from an application \cr
#'  \link[=kinesisanalytics_delete_application_input_processing_configuration]{delete_application_input_processing_configuration} \tab Deletes an InputProcessingConfiguration from an input \cr
#'  \link[=kinesisanalytics_delete_application_output]{delete_application_output} \tab Deletes output destination configuration from your application configuration \cr
#'  \link[=kinesisanalytics_delete_application_reference_data_source]{delete_application_reference_data_source} \tab Deletes a reference data source configuration from the specified application configuration \cr
#'  \link[=kinesisanalytics_describe_application]{describe_application} \tab Returns information about a specific Amazon Kinesis Analytics application \cr
#'  \link[=kinesisanalytics_discover_input_schema]{discover_input_schema} \tab Infers a schema by evaluating sample records on the specified streaming source (Amazon Kinesis stream or Amazon Kinesis Firehose delivery stream) or S3 object\cr
#'  \link[=kinesisanalytics_list_applications]{list_applications} \tab Returns a list of Amazon Kinesis Analytics applications in your account \cr
#'  \link[=kinesisanalytics_start_application]{start_application} \tab Starts the specified Amazon Kinesis Analytics application \cr
#'  \link[=kinesisanalytics_stop_application]{stop_application} \tab Stops the application from processing input data \cr
#'  \link[=kinesisanalytics_update_application]{update_application} \tab Updates an existing Amazon Kinesis Analytics application 
#' }
#'
#' @rdname kinesisanalytics
#' @export
kinesisanalytics <- function() {
  .kinesisanalytics$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.kinesisanalytics <- list()

.kinesisanalytics$operations <- list()

.kinesisanalytics$metadata <- list(
  service_name = "kinesisanalytics",
  endpoints = list("*" = "kinesisanalytics.{region}.amazonaws.com", "cn-*" = "kinesisanalytics.{region}.amazonaws.com.cn"),
  service_id = "Kinesis Analytics",
  api_version = "2015-08-14",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "KinesisAnalytics_20150814"
)

.kinesisanalytics$handlers <- new_handlers("jsonrpc", "v4")

.kinesisanalytics$service <- function() {
  new_service(.kinesisanalytics$metadata, .kinesisanalytics$handlers)
}
