% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalytics_operations.R
\name{kinesisanalytics_add_application_input_processing_configuration}
\alias{kinesisanalytics_add_application_input_processing_configuration}
\title{Adds an InputProcessingConfiguration to an application}
\usage{
kinesisanalytics_add_application_input_processing_configuration(
  ApplicationName, CurrentApplicationVersionId, InputId,
  InputProcessingConfiguration)
}
\arguments{
\item{ApplicationName}{[required] Name of the application to which you want to add the input processing
configuration.}

\item{CurrentApplicationVersionId}{[required] Version of the application to which you want to add the input processing
configuration. You can use the DescribeApplication operation to get the
current application version. If the version specified is not the current
version, the \code{ConcurrentModificationException} is returned.}

\item{InputId}{[required] The ID of the input configuration to add the input processing
configuration to. You can get a list of the input IDs for an application
using the DescribeApplication operation.}

\item{InputProcessingConfiguration}{[required] The InputProcessingConfiguration to add to the application.}
}
\description{
Adds an InputProcessingConfiguration to an application. An input
processor preprocesses records on the input stream before the
application's SQL code executes. Currently, the only input processor
available is \href{https://aws.amazon.com/documentation/lambda/}{AWS Lambda}.
}
\section{Request syntax}{
\preformatted{svc$add_application_input_processing_configuration(
  ApplicationName = "string",
  CurrentApplicationVersionId = 123,
  InputId = "string",
  InputProcessingConfiguration = list(
    InputLambdaProcessor = list(
      ResourceARN = "string",
      RoleARN = "string"
    )
  )
)
}
}

\keyword{internal}
