# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kafka_service.R
NULL

#' Associates one or more Scram Secrets with an Amazon MSK cluster
#'
#' @description
#' 
#'             <p>Associates one or more Scram Secrets with an Amazon MSK cluster.</p>
#'          
#'
#' @usage
#' kafka_batch_associate_scram_secret(ClusterArn, SecretArnList)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) of the cluster to be updated.</p>
#'          
#' @param SecretArnList &#91;required&#93; 
#'             <p>List of AWS Secrets Manager secret ARNs.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$batch_associate_scram_secret(
#'   ClusterArn = "string",
#'   SecretArnList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_batch_associate_scram_secret
kafka_batch_associate_scram_secret <- function(ClusterArn, SecretArnList) {
  op <- new_operation(
    name = "BatchAssociateScramSecret",
    http_method = "POST",
    http_path = "/v1/clusters/{clusterArn}/scram-secrets",
    paginator = list()
  )
  input <- .kafka$batch_associate_scram_secret_input(ClusterArn = ClusterArn, SecretArnList = SecretArnList)
  output <- .kafka$batch_associate_scram_secret_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$batch_associate_scram_secret <- kafka_batch_associate_scram_secret

#' Creates a new MSK cluster
#'
#' @description
#' 
#'             <p>Creates a new MSK cluster.</p>
#'          
#'
#' @usage
#' kafka_create_cluster(BrokerNodeGroupInfo, ClientAuthentication,
#'   ClusterName, ConfigurationInfo, EncryptionInfo, EnhancedMonitoring,
#'   OpenMonitoring, KafkaVersion, LoggingInfo, NumberOfBrokerNodes, Tags)
#'
#' @param BrokerNodeGroupInfo &#91;required&#93; 
#'             <p>Information about the broker nodes in the cluster.</p>
#'          
#' @param ClientAuthentication 
#'             <p>Includes all client authentication related information.</p>
#'          
#' @param ClusterName &#91;required&#93; 
#'             <p>The name of the cluster.</p>
#'          
#' @param ConfigurationInfo 
#'             <p>Represents the configuration that you want MSK to use for the brokers in a cluster.</p>
#'          
#' @param EncryptionInfo 
#'             <p>Includes all encryption-related information.</p>
#'          
#' @param EnhancedMonitoring 
#'             <p>Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.</p>
#'          
#' @param OpenMonitoring 
#'             <p>The settings for open monitoring.</p>
#'          
#' @param KafkaVersion &#91;required&#93; 
#'             <p>The version of Apache Kafka.</p>
#'          
#' @param LoggingInfo 
#' @param NumberOfBrokerNodes &#91;required&#93; 
#'             <p>The number of broker nodes in the cluster.</p>
#'          
#' @param Tags 
#'             <p>Create tags when creating the cluster.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$create_cluster(
#'   BrokerNodeGroupInfo = list(
#'     BrokerAZDistribution = "DEFAULT",
#'     ClientSubnets = list(
#'       "string"
#'     ),
#'     InstanceType = "string",
#'     SecurityGroups = list(
#'       "string"
#'     ),
#'     StorageInfo = list(
#'       EbsStorageInfo = list(
#'         VolumeSize = 123
#'       )
#'     )
#'   ),
#'   ClientAuthentication = list(
#'     Sasl = list(
#'       Scram = list(
#'         Enabled = TRUE|FALSE
#'       )
#'     ),
#'     Tls = list(
#'       CertificateAuthorityArnList = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ClusterName = "string",
#'   ConfigurationInfo = list(
#'     Arn = "string",
#'     Revision = 123
#'   ),
#'   EncryptionInfo = list(
#'     EncryptionAtRest = list(
#'       DataVolumeKMSKeyId = "string"
#'     ),
#'     EncryptionInTransit = list(
#'       ClientBroker = "TLS"|"TLS_PLAINTEXT"|"PLAINTEXT",
#'       InCluster = TRUE|FALSE
#'     )
#'   ),
#'   EnhancedMonitoring = "DEFAULT"|"PER_BROKER"|"PER_TOPIC_PER_BROKER"|"PER_TOPIC_PER_PARTITION",
#'   OpenMonitoring = list(
#'     Prometheus = list(
#'       JmxExporter = list(
#'         EnabledInBroker = TRUE|FALSE
#'       ),
#'       NodeExporter = list(
#'         EnabledInBroker = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   KafkaVersion = "string",
#'   LoggingInfo = list(
#'     BrokerLogs = list(
#'       CloudWatchLogs = list(
#'         Enabled = TRUE|FALSE,
#'         LogGroup = "string"
#'       ),
#'       Firehose = list(
#'         DeliveryStream = "string",
#'         Enabled = TRUE|FALSE
#'       ),
#'       S3 = list(
#'         Bucket = "string",
#'         Enabled = TRUE|FALSE,
#'         Prefix = "string"
#'       )
#'     )
#'   ),
#'   NumberOfBrokerNodes = 123,
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_create_cluster
kafka_create_cluster <- function(BrokerNodeGroupInfo, ClientAuthentication = NULL, ClusterName, ConfigurationInfo = NULL, EncryptionInfo = NULL, EnhancedMonitoring = NULL, OpenMonitoring = NULL, KafkaVersion, LoggingInfo = NULL, NumberOfBrokerNodes, Tags = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/v1/clusters",
    paginator = list()
  )
  input <- .kafka$create_cluster_input(BrokerNodeGroupInfo = BrokerNodeGroupInfo, ClientAuthentication = ClientAuthentication, ClusterName = ClusterName, ConfigurationInfo = ConfigurationInfo, EncryptionInfo = EncryptionInfo, EnhancedMonitoring = EnhancedMonitoring, OpenMonitoring = OpenMonitoring, KafkaVersion = KafkaVersion, LoggingInfo = LoggingInfo, NumberOfBrokerNodes = NumberOfBrokerNodes, Tags = Tags)
  output <- .kafka$create_cluster_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$create_cluster <- kafka_create_cluster

#' Creates a new MSK configuration
#'
#' @description
#' 
#'             <p>Creates a new MSK configuration.</p>
#'          
#'
#' @usage
#' kafka_create_configuration(Description, KafkaVersions, Name,
#'   ServerProperties)
#'
#' @param Description 
#'             <p>The description of the configuration.</p>
#'          
#' @param KafkaVersions 
#'             <p>The versions of Apache Kafka with which you can use this MSK configuration.</p>
#'          
#' @param Name &#91;required&#93; 
#'             <p>The name of the configuration.</p>
#'          
#' @param ServerProperties &#91;required&#93; 
#'             <p>Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded. 
#'                When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration(
#'   Description = "string",
#'   KafkaVersions = list(
#'     "string"
#'   ),
#'   Name = "string",
#'   ServerProperties = raw
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_create_configuration
kafka_create_configuration <- function(Description = NULL, KafkaVersions = NULL, Name, ServerProperties) {
  op <- new_operation(
    name = "CreateConfiguration",
    http_method = "POST",
    http_path = "/v1/configurations",
    paginator = list()
  )
  input <- .kafka$create_configuration_input(Description = Description, KafkaVersions = KafkaVersions, Name = Name, ServerProperties = ServerProperties)
  output <- .kafka$create_configuration_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$create_configuration <- kafka_create_configuration

#' Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in
#' the request
#'
#' @description
#' 
#'             <p>Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.</p>
#'          
#'
#' @usage
#' kafka_delete_cluster(ClusterArn, CurrentVersion)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>
#'          
#' @param CurrentVersion 
#'             <p>The current version of the MSK cluster.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$delete_cluster(
#'   ClusterArn = "string",
#'   CurrentVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_delete_cluster
kafka_delete_cluster <- function(ClusterArn, CurrentVersion = NULL) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "DELETE",
    http_path = "/v1/clusters/{clusterArn}",
    paginator = list()
  )
  input <- .kafka$delete_cluster_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion)
  output <- .kafka$delete_cluster_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$delete_cluster <- kafka_delete_cluster

#' Deletes an MSK Configuration
#'
#' @description
#' 
#'             <p>Deletes an MSK Configuration.</p>
#'          
#'
#' @usage
#' kafka_delete_configuration(Arn)
#'
#' @param Arn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies an MSK configuration.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration(
#'   Arn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_delete_configuration
kafka_delete_configuration <- function(Arn) {
  op <- new_operation(
    name = "DeleteConfiguration",
    http_method = "DELETE",
    http_path = "/v1/configurations/{arn}",
    paginator = list()
  )
  input <- .kafka$delete_configuration_input(Arn = Arn)
  output <- .kafka$delete_configuration_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$delete_configuration <- kafka_delete_configuration

#' Returns a description of the MSK cluster whose Amazon Resource Name
#' (ARN) is specified in the request
#'
#' @description
#' 
#'             <p>Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.</p>
#'          
#'
#' @usage
#' kafka_describe_cluster(ClusterArn)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster(
#'   ClusterArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_describe_cluster
kafka_describe_cluster <- function(ClusterArn) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}",
    paginator = list()
  )
  input <- .kafka$describe_cluster_input(ClusterArn = ClusterArn)
  output <- .kafka$describe_cluster_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_cluster <- kafka_describe_cluster

#' Returns a description of the cluster operation specified by the ARN
#'
#' @description
#' 
#'             <p>Returns a description of the cluster operation specified by the ARN.</p>
#'          
#'
#' @usage
#' kafka_describe_cluster_operation(ClusterOperationArn)
#'
#' @param ClusterOperationArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the MSK cluster operation.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster_operation(
#'   ClusterOperationArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_describe_cluster_operation
kafka_describe_cluster_operation <- function(ClusterOperationArn) {
  op <- new_operation(
    name = "DescribeClusterOperation",
    http_method = "GET",
    http_path = "/v1/operations/{clusterOperationArn}",
    paginator = list()
  )
  input <- .kafka$describe_cluster_operation_input(ClusterOperationArn = ClusterOperationArn)
  output <- .kafka$describe_cluster_operation_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_cluster_operation <- kafka_describe_cluster_operation

#' Returns a description of this MSK configuration
#'
#' @description
#' 
#'             <p>Returns a description of this MSK configuration.</p>
#'          
#'
#' @usage
#' kafka_describe_configuration(Arn)
#'
#' @param Arn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies an MSK configuration and all of its revisions.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration(
#'   Arn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_describe_configuration
kafka_describe_configuration <- function(Arn) {
  op <- new_operation(
    name = "DescribeConfiguration",
    http_method = "GET",
    http_path = "/v1/configurations/{arn}",
    paginator = list()
  )
  input <- .kafka$describe_configuration_input(Arn = Arn)
  output <- .kafka$describe_configuration_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_configuration <- kafka_describe_configuration

#' Returns a description of this revision of the configuration
#'
#' @description
#' 
#'             <p>Returns a description of this revision of the configuration.</p>
#'          
#'
#' @usage
#' kafka_describe_configuration_revision(Arn, Revision)
#'
#' @param Arn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies an MSK configuration and all of its revisions.</p>
#'          
#' @param Revision &#91;required&#93; 
#'             <p>A string that uniquely identifies a revision of an MSK configuration.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_revision(
#'   Arn = "string",
#'   Revision = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_describe_configuration_revision
kafka_describe_configuration_revision <- function(Arn, Revision) {
  op <- new_operation(
    name = "DescribeConfigurationRevision",
    http_method = "GET",
    http_path = "/v1/configurations/{arn}/revisions/{revision}",
    paginator = list()
  )
  input <- .kafka$describe_configuration_revision_input(Arn = Arn, Revision = Revision)
  output <- .kafka$describe_configuration_revision_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_configuration_revision <- kafka_describe_configuration_revision

#' Disassociates one or more Scram Secrets from an Amazon MSK cluster
#'
#' @description
#' 
#'             <p>Disassociates one or more Scram Secrets from an Amazon MSK cluster.</p>
#'          
#'
#' @usage
#' kafka_batch_disassociate_scram_secret(ClusterArn, SecretArnList)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) of the cluster to be updated.</p>
#'          
#' @param SecretArnList &#91;required&#93; 
#'             <p>List of AWS Secrets Manager secret ARNs.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$batch_disassociate_scram_secret(
#'   ClusterArn = "string",
#'   SecretArnList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_batch_disassociate_scram_secret
kafka_batch_disassociate_scram_secret <- function(ClusterArn, SecretArnList) {
  op <- new_operation(
    name = "BatchDisassociateScramSecret",
    http_method = "PATCH",
    http_path = "/v1/clusters/{clusterArn}/scram-secrets",
    paginator = list()
  )
  input <- .kafka$batch_disassociate_scram_secret_input(ClusterArn = ClusterArn, SecretArnList = SecretArnList)
  output <- .kafka$batch_disassociate_scram_secret_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$batch_disassociate_scram_secret <- kafka_batch_disassociate_scram_secret

#' A list of brokers that a client application can use to bootstrap
#'
#' @description
#' 
#'             <p>A list of brokers that a client application can use to bootstrap.</p>
#'          
#'
#' @usage
#' kafka_get_bootstrap_brokers(ClusterArn)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$get_bootstrap_brokers(
#'   ClusterArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_get_bootstrap_brokers
kafka_get_bootstrap_brokers <- function(ClusterArn) {
  op <- new_operation(
    name = "GetBootstrapBrokers",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/bootstrap-brokers",
    paginator = list()
  )
  input <- .kafka$get_bootstrap_brokers_input(ClusterArn = ClusterArn)
  output <- .kafka$get_bootstrap_brokers_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$get_bootstrap_brokers <- kafka_get_bootstrap_brokers

#' Gets the Apache Kafka versions to which you can update the MSK cluster
#'
#' @description
#' 
#'             <p>Gets the Apache Kafka versions to which you can update the MSK cluster.</p>
#'          
#'
#' @usage
#' kafka_get_compatible_kafka_versions(ClusterArn)
#'
#' @param ClusterArn 
#'             <p>The Amazon Resource Name (ARN) of the cluster check.</p>
#'             
#'
#' @section Request syntax:
#' ```
#' svc$get_compatible_kafka_versions(
#'   ClusterArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_get_compatible_kafka_versions
kafka_get_compatible_kafka_versions <- function(ClusterArn = NULL) {
  op <- new_operation(
    name = "GetCompatibleKafkaVersions",
    http_method = "GET",
    http_path = "/v1/compatible-kafka-versions",
    paginator = list()
  )
  input <- .kafka$get_compatible_kafka_versions_input(ClusterArn = ClusterArn)
  output <- .kafka$get_compatible_kafka_versions_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$get_compatible_kafka_versions <- kafka_get_compatible_kafka_versions

#' Returns a list of all the operations that have been performed on the
#' specified MSK cluster
#'
#' @description
#' 
#'             <p>Returns a list of all the operations that have been performed on the specified MSK cluster.</p>
#'          
#'
#' @usage
#' kafka_list_cluster_operations(ClusterArn, MaxResults, NextToken)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>
#'          
#' @param MaxResults 
#'             <p>The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.</p>
#'          
#' @param NextToken 
#'             <p>The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response. 
#'             To get the next batch, provide this token in your next request.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$list_cluster_operations(
#'   ClusterArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_list_cluster_operations
kafka_list_cluster_operations <- function(ClusterArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListClusterOperations",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/operations",
    paginator = list()
  )
  input <- .kafka$list_cluster_operations_input(ClusterArn = ClusterArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_cluster_operations_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_cluster_operations <- kafka_list_cluster_operations

#' Returns a list of all the MSK clusters in the current Region
#'
#' @description
#' 
#'             <p>Returns a list of all the MSK clusters in the current Region.</p>
#'          
#'
#' @usage
#' kafka_list_clusters(ClusterNameFilter, MaxResults, NextToken)
#'
#' @param ClusterNameFilter 
#'             <p>Specify a prefix of the name of the clusters that you want to list. The service lists all the clusters whose names start with this prefix.</p>
#'          
#' @param MaxResults 
#'             <p>The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.</p>
#'          
#' @param NextToken 
#'             <p>The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response. 
#'             To get the next batch, provide this token in your next request.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$list_clusters(
#'   ClusterNameFilter = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_list_clusters
kafka_list_clusters <- function(ClusterNameFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "GET",
    http_path = "/v1/clusters",
    paginator = list()
  )
  input <- .kafka$list_clusters_input(ClusterNameFilter = ClusterNameFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_clusters_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_clusters <- kafka_list_clusters

#' Returns a list of all the MSK configurations in this Region
#'
#' @description
#' 
#'             <p>Returns a list of all the MSK configurations in this Region.</p>
#'          
#'
#' @usage
#' kafka_list_configuration_revisions(Arn, MaxResults, NextToken)
#'
#' @param Arn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies an MSK configuration and all of its revisions.</p>
#'          
#' @param MaxResults 
#'             <p>The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.</p>
#'          
#' @param NextToken 
#'             <p>The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response. 
#'             To get the next batch, provide this token in your next request.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$list_configuration_revisions(
#'   Arn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_list_configuration_revisions
kafka_list_configuration_revisions <- function(Arn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConfigurationRevisions",
    http_method = "GET",
    http_path = "/v1/configurations/{arn}/revisions",
    paginator = list()
  )
  input <- .kafka$list_configuration_revisions_input(Arn = Arn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_configuration_revisions_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_configuration_revisions <- kafka_list_configuration_revisions

#' Returns a list of all the MSK configurations in this Region
#'
#' @description
#' 
#'             <p>Returns a list of all the MSK configurations in this Region.</p>
#'          
#'
#' @usage
#' kafka_list_configurations(MaxResults, NextToken)
#'
#' @param MaxResults 
#'             <p>The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.</p>
#'          
#' @param NextToken 
#'             <p>The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response. 
#'             To get the next batch, provide this token in your next request.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$list_configurations(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_list_configurations
kafka_list_configurations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConfigurations",
    http_method = "GET",
    http_path = "/v1/configurations",
    paginator = list()
  )
  input <- .kafka$list_configurations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_configurations_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_configurations <- kafka_list_configurations

#' Returns a list of Kafka versions
#'
#' @description
#' 
#'             <p>Returns a list of Kafka versions.</p>
#'          
#'
#' @usage
#' kafka_list_kafka_versions(MaxResults, NextToken)
#'
#' @param MaxResults 
#'             <p>The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.</p>
#' @param NextToken 
#'             <p>The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response. To get the next batch, provide this token in your next request.</p>
#'
#' @section Request syntax:
#' ```
#' svc$list_kafka_versions(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_list_kafka_versions
kafka_list_kafka_versions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListKafkaVersions",
    http_method = "GET",
    http_path = "/v1/kafka-versions",
    paginator = list()
  )
  input <- .kafka$list_kafka_versions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_kafka_versions_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_kafka_versions <- kafka_list_kafka_versions

#' Returns a list of the broker nodes in the cluster
#'
#' @description
#' 
#'             <p>Returns a list of the broker nodes in the cluster.</p>
#'          
#'
#' @usage
#' kafka_list_nodes(ClusterArn, MaxResults, NextToken)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>
#'          
#' @param MaxResults 
#'             <p>The maximum number of results to return in the response. If there are more results, the response includes a NextToken parameter.</p>
#'          
#' @param NextToken 
#'             <p>The paginated results marker. When the result of the operation is truncated, the call returns NextToken in the response. 
#'             To get the next batch, provide this token in your next request.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$list_nodes(
#'   ClusterArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_list_nodes
kafka_list_nodes <- function(ClusterArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListNodes",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/nodes",
    paginator = list()
  )
  input <- .kafka$list_nodes_input(ClusterArn = ClusterArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_nodes_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_nodes <- kafka_list_nodes

#' Returns a list of the Scram Secrets associated with an Amazon MSK
#' cluster
#'
#' @description
#' 
#'             <p>Returns a list of the Scram Secrets associated with an Amazon MSK cluster.</p>
#'          
#'
#' @usage
#' kafka_list_scram_secrets(ClusterArn, MaxResults, NextToken)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The arn of the cluster.</p>
#'          
#' @param MaxResults 
#'             <p>The maxResults of the query.</p>
#'          
#' @param NextToken 
#'             <p>The nextToken of the query.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$list_scram_secrets(
#'   ClusterArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_list_scram_secrets
kafka_list_scram_secrets <- function(ClusterArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListScramSecrets",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/scram-secrets",
    paginator = list()
  )
  input <- .kafka$list_scram_secrets_input(ClusterArn = ClusterArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_scram_secrets_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_scram_secrets <- kafka_list_scram_secrets

#' Returns a list of the tags associated with the specified resource
#'
#' @description
#' 
#'             <p>Returns a list of the tags associated with the specified resource.</p>
#'          
#'
#' @usage
#' kafka_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the resource that's associated with the tags.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_list_tags_for_resource
kafka_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v1/tags/{resourceArn}",
    paginator = list()
  )
  input <- .kafka$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .kafka$list_tags_for_resource_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_tags_for_resource <- kafka_list_tags_for_resource

#' Reboots brokers
#'
#' @description
#' Reboots brokers.
#'
#' @usage
#' kafka_reboot_broker(BrokerIds, ClusterArn)
#'
#' @param BrokerIds &#91;required&#93; 
#'             <p>The list of broker IDs to be rebooted. The reboot-broker operation supports rebooting one broker at a time.</p>
#'          
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) of the cluster to be updated.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$reboot_broker(
#'   BrokerIds = list(
#'     "string"
#'   ),
#'   ClusterArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_reboot_broker
kafka_reboot_broker <- function(BrokerIds, ClusterArn) {
  op <- new_operation(
    name = "RebootBroker",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/reboot-broker",
    paginator = list()
  )
  input <- .kafka$reboot_broker_input(BrokerIds = BrokerIds, ClusterArn = ClusterArn)
  output <- .kafka$reboot_broker_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$reboot_broker <- kafka_reboot_broker

#' Adds tags to the specified MSK resource
#'
#' @description
#' 
#'             <p>Adds tags to the specified MSK resource.</p>
#'          
#'
#' @usage
#' kafka_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the resource that's associated with the tags.</p>
#'          
#' @param Tags &#91;required&#93; 
#'             <p>The key-value pair for the resource tag.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_tag_resource
kafka_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v1/tags/{resourceArn}",
    paginator = list()
  )
  input <- .kafka$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .kafka$tag_resource_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$tag_resource <- kafka_tag_resource

#' Removes the tags associated with the keys that are provided in the query
#'
#' @description
#' 
#'             <p>Removes the tags associated with the keys that are provided in the query.</p>
#'          
#'
#' @usage
#' kafka_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the resource that's associated with the tags.</p>
#'          
#' @param TagKeys &#91;required&#93; 
#'             <p>Tag keys must be unique for a given cluster. In addition, the following restrictions apply:</p>
#'             <ul>
#'                <li>
#'                   <p>Each tag key must be unique. If you add a tag with a key that's already in
#'                   use, your new tag overwrites the existing key-value pair. </p>
#'                </li>
#'                <li>
#'                   <p>You can't start a tag key with aws: because this prefix is reserved for use
#'                   by  AWS.  AWS creates tags that begin with this prefix on your behalf, but
#'                   you can't edit or delete them.</p>
#'                </li>
#'                <li>
#'                   <p>Tag keys must be between 1 and 128 Unicode characters in length.</p>
#'                </li>
#'                <li>
#'                   <p>Tag keys must consist of the following characters: Unicode letters, digits,
#'                   white space, and the following special characters: _ . / = + -
#'                      @@.</p>
#'                </li>
#'             </ul>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_untag_resource
kafka_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v1/tags/{resourceArn}",
    paginator = list()
  )
  input <- .kafka$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .kafka$untag_resource_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$untag_resource <- kafka_untag_resource

#' Updates the number of broker nodes in the cluster
#'
#' @description
#' 
#'             <p>Updates the number of broker nodes in the cluster.</p>
#'          
#'
#' @usage
#' kafka_update_broker_count(ClusterArn, CurrentVersion,
#'   TargetNumberOfBrokerNodes)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>
#'          
#' @param CurrentVersion &#91;required&#93; 
#'             <p>The version of cluster to update from. A successful operation will then generate a new version.</p>
#'          
#' @param TargetNumberOfBrokerNodes &#91;required&#93; 
#'             <p>The number of broker nodes that you want the cluster to have after this operation completes successfully.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$update_broker_count(
#'   ClusterArn = "string",
#'   CurrentVersion = "string",
#'   TargetNumberOfBrokerNodes = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_update_broker_count
kafka_update_broker_count <- function(ClusterArn, CurrentVersion, TargetNumberOfBrokerNodes) {
  op <- new_operation(
    name = "UpdateBrokerCount",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/nodes/count",
    paginator = list()
  )
  input <- .kafka$update_broker_count_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion, TargetNumberOfBrokerNodes = TargetNumberOfBrokerNodes)
  output <- .kafka$update_broker_count_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_broker_count <- kafka_update_broker_count

#' Updates the EBS storage associated with MSK brokers
#'
#' @description
#' 
#'             <p>Updates the EBS storage associated with MSK brokers.</p>
#'          
#'
#' @usage
#' kafka_update_broker_storage(ClusterArn, CurrentVersion,
#'   TargetBrokerEBSVolumeInfo)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>
#'          
#' @param CurrentVersion &#91;required&#93; 
#'             <p>The version of cluster to update from. A successful operation will then generate a new version.</p>
#'          
#' @param TargetBrokerEBSVolumeInfo &#91;required&#93; 
#'             <p>Describes the target volume size and the ID of the broker to apply the update to.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$update_broker_storage(
#'   ClusterArn = "string",
#'   CurrentVersion = "string",
#'   TargetBrokerEBSVolumeInfo = list(
#'     list(
#'       KafkaBrokerNodeId = "string",
#'       VolumeSizeGB = 123
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_update_broker_storage
kafka_update_broker_storage <- function(ClusterArn, CurrentVersion, TargetBrokerEBSVolumeInfo) {
  op <- new_operation(
    name = "UpdateBrokerStorage",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/nodes/storage",
    paginator = list()
  )
  input <- .kafka$update_broker_storage_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion, TargetBrokerEBSVolumeInfo = TargetBrokerEBSVolumeInfo)
  output <- .kafka$update_broker_storage_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_broker_storage <- kafka_update_broker_storage

#' Updates an MSK configuration
#'
#' @description
#' 
#'             <p>Updates an MSK configuration.</p>
#'          
#'
#' @usage
#' kafka_update_configuration(Arn, Description, ServerProperties)
#'
#' @param Arn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) of the configuration.</p>
#'          
#' @param Description 
#'             <p>The description of the configuration revision.</p>
#'          
#' @param ServerProperties &#91;required&#93; 
#'             <p>Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded. 
#'                When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$update_configuration(
#'   Arn = "string",
#'   Description = "string",
#'   ServerProperties = raw
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_update_configuration
kafka_update_configuration <- function(Arn, Description = NULL, ServerProperties) {
  op <- new_operation(
    name = "UpdateConfiguration",
    http_method = "PUT",
    http_path = "/v1/configurations/{arn}",
    paginator = list()
  )
  input <- .kafka$update_configuration_input(Arn = Arn, Description = Description, ServerProperties = ServerProperties)
  output <- .kafka$update_configuration_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_configuration <- kafka_update_configuration

#' Updates the cluster with the configuration that is specified in the
#' request body
#'
#' @description
#' 
#'             <p>Updates the cluster with the configuration that is specified in the request body.</p>
#'          
#'
#' @usage
#' kafka_update_cluster_configuration(ClusterArn, ConfigurationInfo,
#'   CurrentVersion)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>
#'          
#' @param ConfigurationInfo &#91;required&#93; 
#'             <p>Represents the configuration that you want MSK to use for the brokers in a cluster.</p>
#'          
#' @param CurrentVersion &#91;required&#93; 
#'             <p>The version of the cluster that needs to be updated.</p>
#'          
#'
#' @section Request syntax:
#' ```
#' svc$update_cluster_configuration(
#'   ClusterArn = "string",
#'   ConfigurationInfo = list(
#'     Arn = "string",
#'     Revision = 123
#'   ),
#'   CurrentVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_update_cluster_configuration
kafka_update_cluster_configuration <- function(ClusterArn, ConfigurationInfo, CurrentVersion) {
  op <- new_operation(
    name = "UpdateClusterConfiguration",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/configuration",
    paginator = list()
  )
  input <- .kafka$update_cluster_configuration_input(ClusterArn = ClusterArn, ConfigurationInfo = ConfigurationInfo, CurrentVersion = CurrentVersion)
  output <- .kafka$update_cluster_configuration_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_cluster_configuration <- kafka_update_cluster_configuration

#' Updates the Apache Kafka version for the cluster
#'
#' @description
#' 
#'             <p>Updates the Apache Kafka version for the cluster.</p>
#'          
#'
#' @usage
#' kafka_update_cluster_kafka_version(ClusterArn, ConfigurationInfo,
#'   CurrentVersion, TargetKafkaVersion)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) of the cluster to be updated.</p>
#'             
#' @param ConfigurationInfo 
#'             <p>The custom configuration that should be applied on the new version of cluster.</p>
#'             
#' @param CurrentVersion &#91;required&#93; 
#'             <p>Current cluster version.</p>
#'             
#' @param TargetKafkaVersion &#91;required&#93; 
#'             <p>Target Kafka version.</p>
#'             
#'
#' @section Request syntax:
#' ```
#' svc$update_cluster_kafka_version(
#'   ClusterArn = "string",
#'   ConfigurationInfo = list(
#'     Arn = "string",
#'     Revision = 123
#'   ),
#'   CurrentVersion = "string",
#'   TargetKafkaVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_update_cluster_kafka_version
kafka_update_cluster_kafka_version <- function(ClusterArn, ConfigurationInfo = NULL, CurrentVersion, TargetKafkaVersion) {
  op <- new_operation(
    name = "UpdateClusterKafkaVersion",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/version",
    paginator = list()
  )
  input <- .kafka$update_cluster_kafka_version_input(ClusterArn = ClusterArn, ConfigurationInfo = ConfigurationInfo, CurrentVersion = CurrentVersion, TargetKafkaVersion = TargetKafkaVersion)
  output <- .kafka$update_cluster_kafka_version_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_cluster_kafka_version <- kafka_update_cluster_kafka_version

#' Updates the monitoring settings for the cluster
#'
#' @description
#' 
#'             <p>Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.</p>
#'          
#'
#' @usage
#' kafka_update_monitoring(ClusterArn, CurrentVersion, EnhancedMonitoring,
#'   OpenMonitoring, LoggingInfo)
#'
#' @param ClusterArn &#91;required&#93; 
#'             <p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>
#'          
#' @param CurrentVersion &#91;required&#93; 
#'             <p>The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK cluster to find its version. When this update operation is successful, it generates a new cluster version.</p>
#'          
#' @param EnhancedMonitoring 
#'             <p>Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.</p>
#'          
#' @param OpenMonitoring 
#'             <p>The settings for open monitoring.</p>
#'          
#' @param LoggingInfo 
#'
#' @section Request syntax:
#' ```
#' svc$update_monitoring(
#'   ClusterArn = "string",
#'   CurrentVersion = "string",
#'   EnhancedMonitoring = "DEFAULT"|"PER_BROKER"|"PER_TOPIC_PER_BROKER"|"PER_TOPIC_PER_PARTITION",
#'   OpenMonitoring = list(
#'     Prometheus = list(
#'       JmxExporter = list(
#'         EnabledInBroker = TRUE|FALSE
#'       ),
#'       NodeExporter = list(
#'         EnabledInBroker = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   LoggingInfo = list(
#'     BrokerLogs = list(
#'       CloudWatchLogs = list(
#'         Enabled = TRUE|FALSE,
#'         LogGroup = "string"
#'       ),
#'       Firehose = list(
#'         DeliveryStream = "string",
#'         Enabled = TRUE|FALSE
#'       ),
#'       S3 = list(
#'         Bucket = "string",
#'         Enabled = TRUE|FALSE,
#'         Prefix = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_update_monitoring
kafka_update_monitoring <- function(ClusterArn, CurrentVersion, EnhancedMonitoring = NULL, OpenMonitoring = NULL, LoggingInfo = NULL) {
  op <- new_operation(
    name = "UpdateMonitoring",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/monitoring",
    paginator = list()
  )
  input <- .kafka$update_monitoring_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion, EnhancedMonitoring = EnhancedMonitoring, OpenMonitoring = OpenMonitoring, LoggingInfo = LoggingInfo)
  output <- .kafka$update_monitoring_output()
  config <- get_config()
  svc <- .kafka$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_monitoring <- kafka_update_monitoring
